/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.TurboFilterAttachable;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import org.slf4j.Marker;

public final class TurboFilterAttachableImpl
implements TurboFilterAttachable {
    TurboFilter headFilter;
    TurboFilter tailFilter;

    public void addTurboFilter(TurboFilter newFilter) {
        if (this.headFilter == null) {
            this.headFilter = newFilter;
            this.tailFilter = newFilter;
        } else {
            this.tailFilter.setNext(newFilter);
            this.tailFilter = newFilter;
        }
    }

    public TurboFilter getFirstTurboFilter() {
        return this.headFilter;
    }

    public void clearAllTurboFilters() {
        TurboFilter f = this.headFilter;
        while (f != null) {
            TurboFilter next = f.getNext();
            f.setNext(null);
            f = next;
        }
        f = null;
        this.headFilter = null;
        this.tailFilter = null;
    }

    public final FilterReply getTurboFilterChainDecision(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        TurboFilter f = this.headFilter;
        while (f != null) {
            switch (f.decide(marker, logger, level, format, params, t)) {
                case DENY: {
                    return FilterReply.DENY;
                }
                case ACCEPT: {
                    return FilterReply.ACCEPT;
                }
                case NEUTRAL: {
                    f = f.getNext();
                }
            }
        }
        return FilterReply.NEUTRAL;
    }
}

