/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.weaver;

import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bundlebee.weaver.ServiceCallAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCallStats {
    private static Logger LOG = LoggerFactory.getLogger(ServiceCallStats.class);
    private static final int DEFAULT_MAX_SAMPLES = 1000;
    private static final int DEFAULT_MIN_SAMPLES = 5;
    private final Map<URI, Map<ServiceCall, Mean>> URICallMap = new ConcurrentHashMap<URI, Map<ServiceCall, Mean>>();
    private final Map<ServiceCall, Long> callCount = new HashMap<ServiceCall, Long>();
    private final int maxSamples;
    private final int minSamples;

    public ServiceCallStats(int maxSamples, int minSamples) {
        if (maxSamples < 1) {
            throw new IllegalArgumentException("MaxSamples must be greater than 0.");
        }
        if (minSamples > maxSamples) {
            throw new IllegalArgumentException("MinSamples must be less or equal to MaxSamples.");
        }
        if (minSamples < 1) {
            throw new IllegalArgumentException("MinSamples must be greater than 0.");
        }
        this.maxSamples = maxSamples;
        this.minSamples = minSamples;
    }

    public ServiceCallStats() {
        this(1000, 5);
    }

    public int getMaxSamples() {
        return this.maxSamples;
    }

    public int getMinSamples() {
        return this.minSamples;
    }

    public void logLocalCall(Object service, String methodName, Class[] parameterTypes, long duration) {
        this.logCall(ServiceCallAspect.LOCAL_URI, service, methodName, parameterTypes, duration);
    }

    public void logCall(URI uri, Object service, String methodName, Class[] parameterTypes, long duration) {
        URI actualURI;
        URI uRI = actualURI = uri == null ? ServiceCallAspect.LOCAL_URI : uri;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Call to " + actualURI + ": " + duration + " time units");
        }
        ServiceCall serviceCall = new ServiceCall(service, methodName, parameterTypes);
        this.incrementCallCount(serviceCall);
        this.getMean(actualURI, serviceCall).add(duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementCallCount(ServiceCall serviceCall) {
        Map<ServiceCall, Long> map = this.callCount;
        synchronized (map) {
            Long count = this.callCount.get(serviceCall);
            if (count == null) {
                this.callCount.put(serviceCall, 1L);
            } else {
                this.callCount.put(serviceCall, count + 1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCallCount(Object service, String methodName, Class[] parameterTypes) {
        Long count;
        ServiceCall serviceCall = new ServiceCall(service, methodName, parameterTypes);
        Map<ServiceCall, Long> map = this.callCount;
        synchronized (map) {
            count = this.callCount.get(serviceCall);
            if (count == null) {
                count = 0L;
            }
        }
        return count;
    }

    public long getLocalCallMean(Object service, String methodName, Class[] parameterTypes) {
        return this.getMean(ServiceCallAspect.LOCAL_URI, service, methodName, parameterTypes).getMean();
    }

    public long getCallMean(URI uri, Object service, String methodName, Class[] parameterTypes) {
        return this.getMean(uri == null ? ServiceCallAspect.LOCAL_URI : uri, service, methodName, parameterTypes).getMean();
    }

    public boolean isLocalCallCheaper(URI uri, Object service, String methodName, Class[] parameterTypes) {
        long localCallMean = this.getLocalCallMean(service, methodName, parameterTypes);
        long remoteCallMean = this.getCallMean(uri, service, methodName, parameterTypes);
        return localCallMean > 0L && remoteCallMean > 0L && localCallMean < remoteCallMean;
    }

    public boolean isLocalCallCheaper(Object service, String methodName, Class[] parameterTypes) {
        long localCallMean = this.getLocalCallMean(service, methodName, parameterTypes);
        long minRemoteCallMean = -1L;
        for (URI uri : this.URICallMap.keySet()) {
            long remoteCallMean;
            if (uri == ServiceCallAspect.LOCAL_URI || (remoteCallMean = this.getCallMean(uri, service, methodName, parameterTypes)) <= 0L || remoteCallMean >= minRemoteCallMean) continue;
            minRemoteCallMean = remoteCallMean;
        }
        return localCallMean > 0L && minRemoteCallMean > 0L && localCallMean < minRemoteCallMean;
    }

    public URI getMinCallMeanURI(Object service, String methodName, Class[] parameterTypes) {
        long minCallMean = -1L;
        URI minCallMeanURI = null;
        for (URI uri : this.URICallMap.keySet()) {
            long remoteCallMean = this.getCallMean(uri, service, methodName, parameterTypes);
            if (remoteCallMean <= 0L || remoteCallMean >= minCallMean) continue;
            minCallMean = remoteCallMean;
            minCallMeanURI = uri;
        }
        return minCallMeanURI;
    }

    private Mean getMean(URI uri, Object service, String methodName, Class[] parameterTypes) {
        ServiceCall serviceCall = new ServiceCall(service, methodName, parameterTypes);
        return this.getMean(uri, serviceCall);
    }

    private Mean getMean(URI uri, ServiceCall serviceCall) {
        Mean mean;
        Map<ServiceCall, Mean> calls = this.URICallMap.get(uri);
        if (calls == null) {
            calls = new ConcurrentHashMap<ServiceCall, Mean>();
            this.URICallMap.put(uri, calls);
        }
        if ((mean = calls.get(serviceCall)) == null) {
            mean = new Mean(this.maxSamples, this.minSamples);
            calls.put(serviceCall, mean);
        }
        return mean;
    }

    private static class ServiceCall {
        private String className;
        private String methodName;
        private String[] parameterTypeNames;

        private ServiceCall(Object service, String methodName, Class[] parameterTypes) {
            this.className = service.getClass().getName();
            this.methodName = methodName;
            this.parameterTypeNames = new String[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                this.parameterTypeNames[i] = parameterTypes.getClass().getName();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceCall that = (ServiceCall)o;
            if (!this.className.equals(that.className)) {
                return false;
            }
            if (!this.methodName.equals(that.methodName)) {
                return false;
            }
            return Arrays.equals(this.parameterTypeNames, that.parameterTypeNames);
        }

        public int hashCode() {
            int result = this.className.hashCode();
            result = 31 * result + this.methodName.hashCode();
            result = 31 * result + Arrays.hashCode(this.parameterTypeNames);
            return result;
        }

        public String toString() {
            return "ServiceCall[" + this.className + "#" + this.methodName + "(" + Arrays.asList(this.parameterTypeNames) + ")]";
        }
    }

    private static class Mean {
        private List<Long> durations = new LinkedList<Long>();
        private long sum;
        private int maxSamples = 1000;
        private int minSamples = 5;

        private Mean(int maxSamples, int minSamples) {
            if (maxSamples < 1) {
                throw new IllegalArgumentException();
            }
            this.maxSamples = maxSamples;
            this.minSamples = minSamples;
        }

        public synchronized void add(long duration) {
            while (Long.MAX_VALUE - this.sum < duration && !this.durations.isEmpty() || this.durations.size() >= this.maxSamples) {
                this.sum -= this.durations.remove(0).longValue();
            }
            this.durations.add(duration);
            this.sum += duration;
        }

        public synchronized long getMean() {
            if (this.durations.size() < this.minSamples) {
                return -1L;
            }
            return this.sum / (long)this.durations.size();
        }

        public synchronized int getSamples() {
            return this.durations.size();
        }

        public String toString() {
            return "Mean[sum=" + this.sum + ",samples=" + this.durations.size() + "mean=" + this.getMean() + "]";
        }
    }
}

