/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.weaver;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.bundlebee.registry.Registry;
import org.bundlebee.registry.impl.RegistryImpl;
import org.bundlebee.remoteservicecall.BundleLifecycleClient;
import org.bundlebee.remoteservicecall.Call;
import org.bundlebee.remoteservicecall.CallDescriptor;
import org.bundlebee.remoteservicecall.Caller;
import org.bundlebee.remoteservicecall.RemotingException;
import org.bundlebee.remoteservicecall.StaticCallContext;
import org.bundlebee.weaver.DispatchStrategyFactory;
import org.bundlebee.weaver.ServiceCallDispatchStrategy;
import org.bundlebee.weaver.ServiceCallStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCallAspect {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceCallAspect.class);
    private static final ServiceCallStats serviceCallStats = new ServiceCallStats();
    private static final Registry registry;
    private static final ServiceCallDispatchStrategy serviceCallDispatchStrategy;
    public static final URI LOCAL_URI;
    public static final Object CANNOT_EXECUTE_REMOTELY;

    private ServiceCallAspect() {
    }

    public static ServiceCallStats getServiceCallStats() {
        return serviceCallStats;
    }

    private static void unregisterManager(URI uri, Exception e) {
        try {
            registry.unregisterManager(uri.toURL());
            LOG.info("Manager at " + uri + " has been blacklisted/unregistered because of a " + e.toString());
        }
        catch (MalformedURLException e1) {
            LOG.error(e1.toString(), e1);
        }
    }

    private static void logLocalCall(Object service, String methodName, Class[] parameterTypes, long duration) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Local call: " + duration + " nano seconds");
        }
        serviceCallStats.logLocalCall(service, methodName, parameterTypes, duration);
    }

    private static void logRemoteCall(URI uri, Object service, String methodName, Class[] parameterTypes, long duration) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Remote call to " + uri + ": " + duration + " nano seconds");
        }
        serviceCallStats.logCall(uri, service, methodName, parameterTypes, duration);
    }

    private static String getServiceClassName(Object localService) {
        return localService.getClass().getName();
    }

    private static String getServiceFilter(Object localService, String methodname, Class[] parameterTypes) {
        String serviceFilter;
        ArrayList<String> possibleObjectClassNames = new ArrayList<String>();
        possibleObjectClassNames.add(localService.getClass().getName());
        for (Class<?> iface : localService.getClass().getInterfaces()) {
            try {
                iface.getMethod(methodname, parameterTypes);
                possibleObjectClassNames.add(iface.getName());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (possibleObjectClassNames.size() <= 1) {
            serviceFilter = null;
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("(|");
            for (String objectClassName : possibleObjectClassNames) {
                sb.append('(');
                sb.append("objectClass");
                sb.append('=');
                sb.append(objectClassName);
                sb.append(')');
            }
            sb.append(')');
            serviceFilter = sb.toString();
        }
        return serviceFilter;
    }

    public static Object tryRemote(Object service, String methodname, String bundleSymbolicNameVersion, Class[] paramtypes, Object[] args) throws Exception {
        if (StaticCallContext.isForceLocal()) {
            StaticCallContext.clearForceLocal();
            StaticCallContext.setTimeStamp();
            return CANNOT_EXECUTE_REMOTELY;
        }
        long remoteStartTime = System.nanoTime();
        String serviceFilter = ServiceCallAspect.getServiceFilter(service, methodname, paramtypes);
        String serviceClassName = null == serviceFilter ? ServiceCallAspect.getServiceClassName(service) : null;
        URI mgrURI = null;
        URL serviceURL = null;
        try {
            mgrURI = serviceCallDispatchStrategy.getManagerURI(bundleSymbolicNameVersion, service, methodname, paramtypes);
            serviceURL = new URL(BundleLifecycleClient.toDirectoryURL(mgrURI.toURL()), "service");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Service URL: " + serviceURL);
            }
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        try {
            CallDescriptor desc = new CallDescriptor(serviceClassName, serviceFilter, methodname, paramtypes);
            Call c = new Call(RegistryImpl.getInstance().getNodeId(), System.identityHashCode(service), desc, args);
            Object ret = Caller.executeCall(c, serviceURL, service.getClass().getClassLoader());
            ServiceCallAspect.logRemoteCall(mgrURI, service, methodname, paramtypes, System.nanoTime() - remoteStartTime);
            return ret;
        }
        catch (RemotingException ex) {
            ServiceCallAspect.unregisterManager(mgrURI, ex);
        }
        catch (Exception ex) {
            throw ex;
        }
        StaticCallContext.setTimeStamp();
        return CANNOT_EXECUTE_REMOTELY;
    }

    public static void finishLocal(Object service, String methodname, Class[] paramtypes) {
        ServiceCallAspect.logLocalCall(service, methodname, paramtypes, System.nanoTime() - StaticCallContext.getTimeStamp());
    }

    static {
        URI uri = null;
        try {
            uri = new URI("vm://" + RegistryImpl.getInstance().getNodeId() + "/");
        }
        catch (URISyntaxException e) {
            LOG.error(e.toString(), e);
            throw new RuntimeException(e);
        }
        LOCAL_URI = uri;
        registry = RegistryImpl.getInstance();
        serviceCallDispatchStrategy = DispatchStrategyFactory.create(registry, serviceCallStats);
        CANNOT_EXECUTE_REMOTELY = new Object();
    }
}

