/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.registry.directory;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bundlebee.registry.directory.Bundle;
import org.bundlebee.registry.directory.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Grid {
    private Map<Long, Node> nodes = new ConcurrentHashMap<Long, Node>();
    private Map<Bundle, Set<URL>> bundleManagerMap = new ConcurrentHashMap<Bundle, Set<URL>>();

    Grid() {
    }

    Node newNode(long id) {
        return new Node(this, id);
    }

    public Node getNode(long id) {
        return this.nodes.get(id);
    }

    public Collection<Node> getNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    Node addNode(Node node) {
        return this.nodes.put(node.getId(), node);
    }

    void register(Bundle bundle) {
        URL managerURL;
        Set<URL> managerURLs = this.bundleManagerMap.get(bundle);
        if (managerURLs == null) {
            managerURLs = new HashSet<URL>();
            this.bundleManagerMap.put(bundle, managerURLs);
        }
        if ((managerURL = bundle.getNode().getManagerURL()) != null) {
            managerURLs.add(managerURL);
        }
        this.bundleManagerMap.put(bundle, managerURLs);
    }

    void unregister(Bundle bundle) {
        Set<URL> managerURLs = this.bundleManagerMap.get(bundle);
        URL managerURL = bundle.getNode().getManagerURL();
        if (managerURLs == null || managerURL == null) {
            return;
        }
        managerURLs.remove(managerURL);
    }

    void unregisterManager(Node node) {
        URL managerURL = node.getManagerURL();
        for (Set<URL> urls : this.bundleManagerMap.values()) {
            urls.remove(managerURL);
        }
    }

    void registerManager(Node node) {
        for (Bundle bundle : node.getBundles()) {
            this.register(bundle);
        }
    }

    void unregisterNode(long nodeId) {
        Node node = this.nodes.remove(nodeId);
        if (node != null) {
            for (Bundle bundle : node.getBundles()) {
                this.unregister(bundle);
            }
        }
    }

    public Set<URL> getManagers(String bundleSymbolicNameVersion, int bundleState) {
        Bundle bundle = new Bundle(null, bundleSymbolicNameVersion, bundleState);
        Set<URL> managerURLs = this.bundleManagerMap.get(bundle);
        if (managerURLs == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(managerURLs);
    }

    public Set<URL> getManagers() {
        HashSet<URL> urls = new HashSet<URL>();
        for (Node node : this.nodes.values()) {
            if (node.getManagerURL() == null) continue;
            urls.add(node.getManagerURL());
        }
        return Collections.unmodifiableSet(urls);
    }

    public Set<URL> getRepositories() {
        HashSet<URL> urls = new HashSet<URL>();
        for (Node node : this.nodes.values()) {
            if (node.getRepositoryURL() == null) continue;
            urls.add(node.getRepositoryURL());
        }
        return Collections.unmodifiableSet(urls);
    }

    public Collection<Long> getNodeIds() {
        return this.nodes.keySet();
    }

    public String toString() {
        return "Grid[nodes=" + this.nodes.size() + "]";
    }
}

