/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.bundle.obr.resource;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.osgi.impl.bundle.obr.resource.Tag;
import org.osgi.impl.bundle.obr.resource.VersionRange;
import org.osgi.service.obr.Capability;
import org.xmlpull.v1.XmlPullParser;

public class CapabilityImpl
implements Capability {
    String name;
    Map properties = new TreeMap();

    public CapabilityImpl(String name) {
        this.name = name;
    }

    public CapabilityImpl(XmlPullParser parser) throws Exception {
        parser.require(2, null, "capability");
        this.name = parser.getAttributeValue(null, "name");
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("p")) {
                String name = parser.getAttributeValue(null, "n");
                String value = parser.getAttributeValue(null, "v");
                String type = parser.getAttributeValue(null, "t");
                Object v = value;
                if ("nummeric".equals(type)) {
                    v = new Long(value);
                } else if ("version".equals(type)) {
                    v = new VersionRange(value);
                }
                this.addProperty(name, v);
            }
            parser.next();
            parser.require(3, null, "p");
        }
        parser.require(3, null, "capability");
    }

    public void addProperty(String key, Object value) {
        ArrayList<Object> values = (ArrayList<Object>)this.properties.get(key);
        if (values == null) {
            values = new ArrayList<Object>();
            this.properties.put(key, values);
        }
        values.add(value);
    }

    public Tag toXML() {
        return CapabilityImpl.toXML(this);
    }

    public static Tag toXML(Capability capability) {
        Tag tag = new Tag("capability");
        tag.addAttribute("name", capability.getName());
        Map properties = capability.getProperties();
        for (String key : properties.keySet()) {
            List values = (List)properties.get(key);
            for (Object value : values) {
                Tag p = new Tag("p");
                tag.addContent(p);
                p.addAttribute("n", key);
                if (value != null) {
                    p.addAttribute("v", CapabilityImpl.valueString(value));
                    String type = null;
                    if (value instanceof Number) {
                        type = "number";
                    } else if (value.getClass() == VersionRange.class) {
                        type = "version";
                    } else if (value.getClass().isArray()) {
                        type = "set";
                    }
                    if (type == null) continue;
                    p.addAttribute("t", type);
                    continue;
                }
                System.out.println("Missing value " + key);
            }
        }
        return tag;
    }

    private static String valueString(Object value) {
        if (value.getClass().isArray()) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < Array.getLength(value)) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(Array.get(value, i).toString());
                ++i;
            }
            return buf.toString();
        }
        return value.toString();
    }

    public String getName() {
        return this.name;
    }

    public Map getProperties() {
        return this.properties;
    }
}

