/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * SnapshotsPanel.java
 *
 * Created on 08.10.2009, 22:15:22
 */

package org.bundlebee.examples.fractal;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.Timer;

/**
 *
 * @author innoq
 */
public class SnapshotsPanel extends javax.swing.JPanel {

	private final static int MAXSNAPSHOTS = 50;
	private final static int GAP = 2;

	private final LinkedList<SnapshotPanel> mSnapshots = new LinkedList<SnapshotPanel>();
	
    /** Creates new form SnapshotsPanel */
    public SnapshotsPanel() {
        initComponents();
		setPreferredSize(new Dimension( SnapshotPanel.SIZE, 0 ) );
    }


	enum SLIDEMODE { SLIDEDOWN, SLIDEIN };

	class SlideInTimerAction implements ActionListener {
		Timer mTimer;
		int mSlideDownCounter = 0;
		int mSlideInCounter = 0;
		SnapshotPanel mNewSnapshot;
		SLIDEMODE mMode = SLIDEMODE.SLIDEDOWN;

		public SlideInTimerAction( Timer t, SnapshotPanel newsnapshot ) {
			mTimer = t;
			mNewSnapshot = newsnapshot;
		}

		public void actionPerformed(ActionEvent e) {
			if( mMode == SLIDEMODE.SLIDEDOWN ) {
				for( int i=0; i < mSnapshots.size(); i++ ) {
					mSnapshots.get(i).setLocation( 0, (i * (SnapshotPanel.SIZE+GAP)) +mSlideDownCounter );
				}

				mNewSnapshot.setLocation( mSlideDownCounter - SnapshotPanel.SIZE - GAP, 0);
				
				mSlideDownCounter++;
				if( mSlideDownCounter <= SnapshotPanel.SIZE + GAP) {
					mTimer.restart();
				} else {
//					mNewSnapshot.setLocation(SnapshotPanel.SIZE,0);
//					add(mNewSnapshot);
					mSnapshots.addFirst(mNewSnapshot);
//					mMode = SLIDEMODE.SLIDEIN;
				}
//				mTimer.restart();
			}

//			if( mMode == SLIDEMODE.SLIDEIN ) {
//				mNewSnapshot.setLocation(SnapshotPanel.SIZE - mSlideInCounter, 0);
//
//				mSlideInCounter++;
//				if( mSlideInCounter <= SnapshotPanel.SIZE) mTimer.restart();
//
//			}

			repaint();
		}
	}
	
	public void addSnapshot( SnapshotPanel p ) {

		//
		// limit number of snapshots
		//
		if( MAXSNAPSHOTS <= mSnapshots.size() ) {
			remove(mSnapshots.getLast());
			mSnapshots.removeLast();
		}

//		for( int i=0; i < getComponentCount(); i++ ) {
//			getComponent(i).setLocation( 0, (i+1) * (SnapshotPanel.SIZE+GAP) );
//		}

		setPreferredSize(new Dimension( SnapshotPanel.SIZE, (mSnapshots.size()+1)*(SnapshotPanel.SIZE+GAP) ) );
		invalidate();
		getParent().validate();

		add( p );
		Timer t = new Timer(6,null);
		t.addActionListener(new SlideInTimerAction(t,p));
		t.setRepeats(false);
		t.start();

	}

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        setName("Form"); // NOI18N
        setLayout(null);
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables

}
