/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.uma.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.mitre.jwt.signer.service.JWTSigningAndValidationService;
import org.mitre.oauth2.model.AuthenticationHolderEntity;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.repository.AuthenticationHolderRepository;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.oauth2.service.OAuth2TokenEntityService;
import org.mitre.openid.connect.config.ConfigurationPropertiesBean;
import org.mitre.uma.model.Permission;
import org.mitre.uma.model.PermissionTicket;
import org.mitre.uma.model.Policy;
import org.mitre.uma.service.UmaTokenService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Service;

@Service(value="defaultUmaTokenService")
public class DefaultUmaTokenService
implements UmaTokenService {
    @Autowired
    private AuthenticationHolderRepository authenticationHolderRepository;
    @Autowired
    private OAuth2TokenEntityService tokenService;
    @Autowired
    private ClientDetailsEntityService clientService;
    @Autowired
    private ConfigurationPropertiesBean config;
    @Autowired
    private JWTSigningAndValidationService jwtService;

    public OAuth2AccessTokenEntity createRequestingPartyToken(OAuth2Authentication o2auth, PermissionTicket ticket, Policy policy) {
        OAuth2AccessTokenEntity token = new OAuth2AccessTokenEntity();
        AuthenticationHolderEntity authHolder = new AuthenticationHolderEntity();
        authHolder.setAuthentication(o2auth);
        authHolder = this.authenticationHolderRepository.save(authHolder);
        token.setAuthenticationHolder(authHolder);
        ClientDetailsEntity client = this.clientService.loadClientByClientId(o2auth.getOAuth2Request().getClientId());
        token.setClient(client);
        Set ticketScopes = ticket.getPermission().getScopes();
        Set policyScopes = policy.getScopes();
        Permission perm = new Permission();
        perm.setResourceSet(ticket.getPermission().getResourceSet());
        perm.setScopes(new HashSet(Sets.intersection((Set)ticketScopes, (Set)policyScopes)));
        token.setPermissions((Set)Sets.newHashSet((Object[])new Permission[]{perm}));
        JWTClaimsSet.Builder claims = new JWTClaimsSet.Builder();
        claims.audience((List)Lists.newArrayList((Object[])new String[]{ticket.getPermission().getResourceSet().getId().toString()}));
        claims.issuer(this.config.getIssuer());
        claims.jwtID(UUID.randomUUID().toString());
        if (this.config.getRqpTokenLifeTime() != null) {
            Date exp = new Date(System.currentTimeMillis() + this.config.getRqpTokenLifeTime() * 1000L);
            claims.expirationTime(exp);
            token.setExpiration(exp);
        }
        JWSAlgorithm signingAlgorithm = this.jwtService.getDefaultSigningAlgorithm();
        JWSHeader header = new JWSHeader(signingAlgorithm, null, null, null, null, null, null, null, null, null, this.jwtService.getDefaultSignerKeyId(), null, null);
        SignedJWT signed = new SignedJWT(header, claims.build());
        this.jwtService.signJwt(signed);
        token.setJwt((JWT)signed);
        this.tokenService.saveAccessToken(token);
        return token;
    }
}

