/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.uma.service.impl;

import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.mitre.oauth2.model.RegisteredClient;
import org.mitre.openid.connect.client.service.RegisteredClientService;
import org.mitre.uma.model.SavedRegisteredClient;
import org.mitre.uma.service.SavedRegisteredClientService;
import org.mitre.util.jpa.JpaUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JpaRegisteredClientService
implements RegisteredClientService,
SavedRegisteredClientService {
    @PersistenceContext(unitName="defaultPersistenceUnit")
    private EntityManager em;

    public RegisteredClient getByIssuer(String issuer) {
        SavedRegisteredClient saved = this.getSavedRegisteredClientFromStorage(issuer);
        if (saved == null) {
            return null;
        }
        return saved.getRegisteredClient();
    }

    @Transactional(value="defaultTransactionManager")
    public void save(String issuer, RegisteredClient client) {
        SavedRegisteredClient saved = this.getSavedRegisteredClientFromStorage(issuer);
        if (saved == null) {
            saved = new SavedRegisteredClient();
            saved.setIssuer(issuer);
        }
        saved.setRegisteredClient(client);
        this.em.persist((Object)saved);
    }

    private SavedRegisteredClient getSavedRegisteredClientFromStorage(String issuer) {
        TypedQuery query = this.em.createQuery("SELECT c from SavedRegisteredClient c where c.issuer = :issuer", SavedRegisteredClient.class);
        query.setParameter("issuer", (Object)issuer);
        SavedRegisteredClient saved = (SavedRegisteredClient)JpaUtil.getSingleResult((List)query.getResultList());
        return saved;
    }

    public Collection<SavedRegisteredClient> getAll() {
        TypedQuery query = this.em.createQuery("SELECT c from SavedRegisteredClient c", SavedRegisteredClient.class);
        return query.getResultList();
    }
}

