/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.introspectingfilter.service.impl;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.mitre.oauth2.introspectingfilter.service.IntrospectionAuthorityGranter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.common.util.OAuth2Utils;

public class ScopeBasedIntrospectionAuthoritiesGranter
implements IntrospectionAuthorityGranter {
    private List<GrantedAuthority> authorities = AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_API"});

    @Override
    public List<GrantedAuthority> getAuthorities(JsonObject introspectionResponse) {
        ArrayList<GrantedAuthority> auth = new ArrayList<GrantedAuthority>(this.getAuthorities());
        if (introspectionResponse.has("scope") && introspectionResponse.get("scope").isJsonPrimitive()) {
            String scopeString = introspectionResponse.get("scope").getAsString();
            Set scopes = OAuth2Utils.parseParameterList((String)scopeString);
            for (String scope : scopes) {
                auth.add((GrantedAuthority)new SimpleGrantedAuthority("OAUTH_SCOPE_" + scope));
            }
        }
        return auth;
    }

    public List<GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public void setAuthorities(List<GrantedAuthority> authorities) {
        this.authorities = authorities;
    }
}

