/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.model;

import com.google.gson.JsonObject;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jwt.JWT;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.PKCEAlgorithm;
import org.springframework.security.core.GrantedAuthority;

public class RegisteredClient {
    private String registrationAccessToken;
    private String registrationClientUri;
    private Date clientSecretExpiresAt;
    private Date clientIdIssuedAt;
    private ClientDetailsEntity client;
    private JsonObject src;

    public RegisteredClient() {
        this.client = new ClientDetailsEntity();
    }

    public RegisteredClient(ClientDetailsEntity client) {
        this.client = client;
    }

    public RegisteredClient(ClientDetailsEntity client, String registrationAccessToken, String registrationClientUri) {
        this.client = client;
        this.registrationAccessToken = registrationAccessToken;
        this.registrationClientUri = registrationClientUri;
    }

    public ClientDetailsEntity getClient() {
        return this.client;
    }

    public void setClient(ClientDetailsEntity client) {
        this.client = client;
    }

    public String getClientDescription() {
        return this.client.getClientDescription();
    }

    public void setClientDescription(String clientDescription) {
        this.client.setClientDescription(clientDescription);
    }

    public boolean isAllowRefresh() {
        return this.client.isAllowRefresh();
    }

    public boolean isReuseRefreshToken() {
        return this.client.isReuseRefreshToken();
    }

    public void setReuseRefreshToken(boolean reuseRefreshToken) {
        this.client.setReuseRefreshToken(reuseRefreshToken);
    }

    public Integer getIdTokenValiditySeconds() {
        return this.client.getIdTokenValiditySeconds();
    }

    public void setIdTokenValiditySeconds(Integer idTokenValiditySeconds) {
        this.client.setIdTokenValiditySeconds(idTokenValiditySeconds);
    }

    public boolean isDynamicallyRegistered() {
        return this.client.isDynamicallyRegistered();
    }

    public void setDynamicallyRegistered(boolean dynamicallyRegistered) {
        this.client.setDynamicallyRegistered(dynamicallyRegistered);
    }

    public boolean isAllowIntrospection() {
        return this.client.isAllowIntrospection();
    }

    public void setAllowIntrospection(boolean allowIntrospection) {
        this.client.setAllowIntrospection(allowIntrospection);
    }

    public boolean isSecretRequired() {
        return this.client.isSecretRequired();
    }

    public boolean isScoped() {
        return this.client.isScoped();
    }

    public String getClientId() {
        return this.client.getClientId();
    }

    public void setClientId(String clientId) {
        this.client.setClientId(clientId);
    }

    public String getClientSecret() {
        return this.client.getClientSecret();
    }

    public void setClientSecret(String clientSecret) {
        this.client.setClientSecret(clientSecret);
    }

    public Set<String> getScope() {
        return this.client.getScope();
    }

    public void setScope(Set<String> scope) {
        this.client.setScope(scope);
    }

    public Set<String> getGrantTypes() {
        return this.client.getGrantTypes();
    }

    public void setGrantTypes(Set<String> grantTypes) {
        this.client.setGrantTypes(grantTypes);
    }

    public Set<String> getAuthorizedGrantTypes() {
        return this.client.getAuthorizedGrantTypes();
    }

    public Set<GrantedAuthority> getAuthorities() {
        return this.client.getAuthorities();
    }

    public void setAuthorities(Set<GrantedAuthority> authorities) {
        this.client.setAuthorities(authorities);
    }

    public Integer getAccessTokenValiditySeconds() {
        return this.client.getAccessTokenValiditySeconds();
    }

    public void setAccessTokenValiditySeconds(Integer accessTokenValiditySeconds) {
        this.client.setAccessTokenValiditySeconds(accessTokenValiditySeconds);
    }

    public Integer getRefreshTokenValiditySeconds() {
        return this.client.getRefreshTokenValiditySeconds();
    }

    public void setRefreshTokenValiditySeconds(Integer refreshTokenValiditySeconds) {
        this.client.setRefreshTokenValiditySeconds(refreshTokenValiditySeconds);
    }

    public Set<String> getRedirectUris() {
        return this.client.getRedirectUris();
    }

    public void setRedirectUris(Set<String> redirectUris) {
        this.client.setRedirectUris(redirectUris);
    }

    public Set<String> getRegisteredRedirectUri() {
        return this.client.getRegisteredRedirectUri();
    }

    public Set<String> getResourceIds() {
        return this.client.getResourceIds();
    }

    public void setResourceIds(Set<String> resourceIds) {
        this.client.setResourceIds(resourceIds);
    }

    public Map<String, Object> getAdditionalInformation() {
        return this.client.getAdditionalInformation();
    }

    public ClientDetailsEntity.AppType getApplicationType() {
        return this.client.getApplicationType();
    }

    public void setApplicationType(ClientDetailsEntity.AppType applicationType) {
        this.client.setApplicationType(applicationType);
    }

    public String getClientName() {
        return this.client.getClientName();
    }

    public void setClientName(String clientName) {
        this.client.setClientName(clientName);
    }

    public ClientDetailsEntity.AuthMethod getTokenEndpointAuthMethod() {
        return this.client.getTokenEndpointAuthMethod();
    }

    public void setTokenEndpointAuthMethod(ClientDetailsEntity.AuthMethod tokenEndpointAuthMethod) {
        this.client.setTokenEndpointAuthMethod(tokenEndpointAuthMethod);
    }

    public ClientDetailsEntity.SubjectType getSubjectType() {
        return this.client.getSubjectType();
    }

    public void setSubjectType(ClientDetailsEntity.SubjectType subjectType) {
        this.client.setSubjectType(subjectType);
    }

    public Set<String> getContacts() {
        return this.client.getContacts();
    }

    public void setContacts(Set<String> contacts) {
        this.client.setContacts(contacts);
    }

    public String getLogoUri() {
        return this.client.getLogoUri();
    }

    public void setLogoUri(String logoUri) {
        this.client.setLogoUri(logoUri);
    }

    public String getPolicyUri() {
        return this.client.getPolicyUri();
    }

    public void setPolicyUri(String policyUri) {
        this.client.setPolicyUri(policyUri);
    }

    public String getClientUri() {
        return this.client.getClientUri();
    }

    public void setClientUri(String clientUri) {
        this.client.setClientUri(clientUri);
    }

    public String getTosUri() {
        return this.client.getTosUri();
    }

    public void setTosUri(String tosUri) {
        this.client.setTosUri(tosUri);
    }

    public String getJwksUri() {
        return this.client.getJwksUri();
    }

    public void setJwksUri(String jwksUri) {
        this.client.setJwksUri(jwksUri);
    }

    public JWKSet getJwks() {
        return this.client.getJwks();
    }

    public void setJwks(JWKSet jwks) {
        this.client.setJwks(jwks);
    }

    public String getSectorIdentifierUri() {
        return this.client.getSectorIdentifierUri();
    }

    public void setSectorIdentifierUri(String sectorIdentifierUri) {
        this.client.setSectorIdentifierUri(sectorIdentifierUri);
    }

    public Integer getDefaultMaxAge() {
        return this.client.getDefaultMaxAge();
    }

    public void setDefaultMaxAge(Integer defaultMaxAge) {
        this.client.setDefaultMaxAge(defaultMaxAge);
    }

    public Boolean getRequireAuthTime() {
        return this.client.getRequireAuthTime();
    }

    public void setRequireAuthTime(Boolean requireAuthTime) {
        this.client.setRequireAuthTime(requireAuthTime);
    }

    public Set<String> getResponseTypes() {
        return this.client.getResponseTypes();
    }

    public void setResponseTypes(Set<String> responseTypes) {
        this.client.setResponseTypes(responseTypes);
    }

    public Set<String> getDefaultACRvalues() {
        return this.client.getDefaultACRvalues();
    }

    public void setDefaultACRvalues(Set<String> defaultACRvalues) {
        this.client.setDefaultACRvalues(defaultACRvalues);
    }

    public String getInitiateLoginUri() {
        return this.client.getInitiateLoginUri();
    }

    public void setInitiateLoginUri(String initiateLoginUri) {
        this.client.setInitiateLoginUri(initiateLoginUri);
    }

    public Set<String> getPostLogoutRedirectUris() {
        return this.client.getPostLogoutRedirectUris();
    }

    public void setPostLogoutRedirectUris(Set<String> postLogoutRedirectUri) {
        this.client.setPostLogoutRedirectUris(postLogoutRedirectUri);
    }

    public Set<String> getRequestUris() {
        return this.client.getRequestUris();
    }

    public void setRequestUris(Set<String> requestUris) {
        this.client.setRequestUris(requestUris);
    }

    public JWSAlgorithm getRequestObjectSigningAlg() {
        return this.client.getRequestObjectSigningAlg();
    }

    public void setRequestObjectSigningAlg(JWSAlgorithm requestObjectSigningAlg) {
        this.client.setRequestObjectSigningAlg(requestObjectSigningAlg);
    }

    public JWSAlgorithm getUserInfoSignedResponseAlg() {
        return this.client.getUserInfoSignedResponseAlg();
    }

    public void setUserInfoSignedResponseAlg(JWSAlgorithm userInfoSignedResponseAlg) {
        this.client.setUserInfoSignedResponseAlg(userInfoSignedResponseAlg);
    }

    public JWEAlgorithm getUserInfoEncryptedResponseAlg() {
        return this.client.getUserInfoEncryptedResponseAlg();
    }

    public void setUserInfoEncryptedResponseAlg(JWEAlgorithm userInfoEncryptedResponseAlg) {
        this.client.setUserInfoEncryptedResponseAlg(userInfoEncryptedResponseAlg);
    }

    public EncryptionMethod getUserInfoEncryptedResponseEnc() {
        return this.client.getUserInfoEncryptedResponseEnc();
    }

    public void setUserInfoEncryptedResponseEnc(EncryptionMethod userInfoEncryptedResponseEnc) {
        this.client.setUserInfoEncryptedResponseEnc(userInfoEncryptedResponseEnc);
    }

    public JWSAlgorithm getIdTokenSignedResponseAlg() {
        return this.client.getIdTokenSignedResponseAlg();
    }

    public void setIdTokenSignedResponseAlg(JWSAlgorithm idTokenSignedResponseAlg) {
        this.client.setIdTokenSignedResponseAlg(idTokenSignedResponseAlg);
    }

    public JWEAlgorithm getIdTokenEncryptedResponseAlg() {
        return this.client.getIdTokenEncryptedResponseAlg();
    }

    public void setIdTokenEncryptedResponseAlg(JWEAlgorithm idTokenEncryptedResponseAlg) {
        this.client.setIdTokenEncryptedResponseAlg(idTokenEncryptedResponseAlg);
    }

    public EncryptionMethod getIdTokenEncryptedResponseEnc() {
        return this.client.getIdTokenEncryptedResponseEnc();
    }

    public void setIdTokenEncryptedResponseEnc(EncryptionMethod idTokenEncryptedResponseEnc) {
        this.client.setIdTokenEncryptedResponseEnc(idTokenEncryptedResponseEnc);
    }

    public JWSAlgorithm getTokenEndpointAuthSigningAlg() {
        return this.client.getTokenEndpointAuthSigningAlg();
    }

    public void setTokenEndpointAuthSigningAlg(JWSAlgorithm tokenEndpointAuthSigningAlg) {
        this.client.setTokenEndpointAuthSigningAlg(tokenEndpointAuthSigningAlg);
    }

    public Date getCreatedAt() {
        return this.client.getCreatedAt();
    }

    public void setCreatedAt(Date createdAt) {
        this.client.setCreatedAt(createdAt);
    }

    public String getRegistrationAccessToken() {
        return this.registrationAccessToken;
    }

    public void setRegistrationAccessToken(String registrationAccessToken) {
        this.registrationAccessToken = registrationAccessToken;
    }

    public String getRegistrationClientUri() {
        return this.registrationClientUri;
    }

    public void setRegistrationClientUri(String registrationClientUri) {
        this.registrationClientUri = registrationClientUri;
    }

    public Date getClientSecretExpiresAt() {
        return this.clientSecretExpiresAt;
    }

    public void setClientSecretExpiresAt(Date expiresAt) {
        this.clientSecretExpiresAt = expiresAt;
    }

    public Date getClientIdIssuedAt() {
        return this.clientIdIssuedAt;
    }

    public void setClientIdIssuedAt(Date issuedAt) {
        this.clientIdIssuedAt = issuedAt;
    }

    public Set<String> getClaimsRedirectUris() {
        return this.client.getClaimsRedirectUris();
    }

    public void setClaimsRedirectUris(Set<String> claimsRedirectUris) {
        this.client.setClaimsRedirectUris(claimsRedirectUris);
    }

    public JWT getSoftwareStatement() {
        return this.client.getSoftwareStatement();
    }

    public void setSoftwareStatement(JWT softwareStatement) {
        this.client.setSoftwareStatement(softwareStatement);
    }

    public PKCEAlgorithm getCodeChallengeMethod() {
        return this.client.getCodeChallengeMethod();
    }

    public void setCodeChallengeMethod(PKCEAlgorithm codeChallengeMethod) {
        this.client.setCodeChallengeMethod(codeChallengeMethod);
    }

    public JsonObject getSource() {
        return this.src;
    }

    public void setSource(JsonObject src) {
        this.src = src;
    }

    public Integer getDeviceCodeValiditySeconds() {
        return this.client.getDeviceCodeValiditySeconds();
    }

    public void setDeviceCodeValiditySeconds(Integer deviceCodeValiditySeconds) {
        this.client.setDeviceCodeValiditySeconds(deviceCodeValiditySeconds);
    }

    public String getSoftwareId() {
        return this.client.getSoftwareId();
    }

    public void setSoftwareId(String softwareId) {
        this.client.setSoftwareId(softwareId);
    }

    public String getSoftwareVersion() {
        return this.client.getSoftwareVersion();
    }

    public void setSoftwareVersion(String softwareVersion) {
        this.client.setSoftwareVersion(softwareVersion);
    }
}

