/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.client;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.HttpClientBuilder;
import org.mitre.openid.connect.config.ServerConfiguration;
import org.mitre.openid.connect.model.DefaultUserInfo;
import org.mitre.openid.connect.model.PendingOIDCAuthenticationToken;
import org.mitre.openid.connect.model.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestTemplate;

public class UserInfoFetcher {
    private static final Logger logger = LoggerFactory.getLogger(UserInfoFetcher.class);
    private LoadingCache<PendingOIDCAuthenticationToken, UserInfo> cache;

    public UserInfoFetcher() {
        this((HttpClient)HttpClientBuilder.create().useSystemProperties().build());
    }

    public UserInfoFetcher(HttpClient httpClient) {
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).maximumSize(100L).build((CacheLoader)new UserInfoLoader(httpClient));
    }

    public UserInfo loadUserInfo(PendingOIDCAuthenticationToken token) {
        try {
            return (UserInfo)this.cache.get((Object)token);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            logger.warn("Couldn't load User Info from token: " + e.getMessage());
            return null;
        }
    }

    protected UserInfo fromJson(JsonObject userInfoJson) {
        return DefaultUserInfo.fromJson((JsonObject)userInfoJson);
    }

    private class UserInfoLoader
    extends CacheLoader<PendingOIDCAuthenticationToken, UserInfo> {
        private HttpComponentsClientHttpRequestFactory factory;

        UserInfoLoader(HttpClient httpClient) {
            this.factory = new HttpComponentsClientHttpRequestFactory(httpClient);
        }

        public UserInfo load(final PendingOIDCAuthenticationToken token) throws URISyntaxException {
            RestTemplate restTemplate;
            ServerConfiguration serverConfiguration = token.getServerConfiguration();
            if (serverConfiguration == null) {
                logger.warn("No server configuration found.");
                return null;
            }
            if (Strings.isNullOrEmpty((String)serverConfiguration.getUserInfoUri())) {
                logger.warn("No userinfo endpoint, not fetching.");
                return null;
            }
            String userInfoString = null;
            if (serverConfiguration.getUserInfoTokenMethod() == null || serverConfiguration.getUserInfoTokenMethod().equals((Object)ServerConfiguration.UserInfoTokenMethod.HEADER)) {
                RestTemplate restTemplate2 = new RestTemplate((ClientHttpRequestFactory)this.factory){

                    protected ClientHttpRequest createRequest(URI url, HttpMethod method) throws IOException {
                        ClientHttpRequest httpRequest = super.createRequest(url, method);
                        httpRequest.getHeaders().add("Authorization", String.format("Bearer %s", token.getAccessTokenValue()));
                        return httpRequest;
                    }
                };
                userInfoString = (String)restTemplate2.getForObject(serverConfiguration.getUserInfoUri(), String.class, new Object[0]);
            } else if (serverConfiguration.getUserInfoTokenMethod().equals((Object)ServerConfiguration.UserInfoTokenMethod.FORM)) {
                LinkedMultiValueMap form = new LinkedMultiValueMap();
                form.add((Object)"access_token", (Object)token.getAccessTokenValue());
                restTemplate = new RestTemplate((ClientHttpRequestFactory)this.factory);
                userInfoString = (String)restTemplate.postForObject(serverConfiguration.getUserInfoUri(), (Object)form, String.class, new Object[0]);
            } else if (serverConfiguration.getUserInfoTokenMethod().equals((Object)ServerConfiguration.UserInfoTokenMethod.QUERY)) {
                URIBuilder builder = new URIBuilder(serverConfiguration.getUserInfoUri());
                builder.setParameter("access_token", token.getAccessTokenValue());
                restTemplate = new RestTemplate((ClientHttpRequestFactory)this.factory);
                userInfoString = (String)restTemplate.getForObject(builder.toString(), String.class, new Object[0]);
            }
            if (!Strings.isNullOrEmpty(userInfoString)) {
                JsonObject userInfoJson = new JsonParser().parse(userInfoString).getAsJsonObject();
                UserInfo userInfo = UserInfoFetcher.this.fromJson(userInfoJson);
                return userInfo;
            }
            throw new IllegalArgumentException("Unable to load user info");
        }
    }
}

