/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.repository.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.mitre.data.DefaultPageCriteria;
import org.mitre.data.PageCriteria;
import org.mitre.oauth2.model.AuthenticationHolderEntity;
import org.mitre.oauth2.repository.AuthenticationHolderRepository;
import org.mitre.util.jpa.JpaUtil;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(value="defaultTransactionManager")
public class JpaAuthenticationHolderRepository
implements AuthenticationHolderRepository {
    private static final int MAXEXPIREDRESULTS = 1000;
    @PersistenceContext(unitName="defaultPersistenceUnit")
    private EntityManager manager;

    public List<AuthenticationHolderEntity> getAll() {
        TypedQuery query = this.manager.createNamedQuery("AuthenticationHolderEntity.getAll", AuthenticationHolderEntity.class);
        return query.getResultList();
    }

    public AuthenticationHolderEntity getById(Long id) {
        return (AuthenticationHolderEntity)this.manager.find(AuthenticationHolderEntity.class, (Object)id);
    }

    @Transactional(value="defaultTransactionManager")
    public void remove(AuthenticationHolderEntity a) {
        AuthenticationHolderEntity found = this.getById(a.getId());
        if (found == null) {
            throw new IllegalArgumentException("AuthenticationHolderEntity not found: " + a);
        }
        this.manager.remove((Object)found);
    }

    @Transactional(value="defaultTransactionManager")
    public AuthenticationHolderEntity save(AuthenticationHolderEntity a) {
        return (AuthenticationHolderEntity)JpaUtil.saveOrUpdate((Object)a.getId(), (EntityManager)this.manager, (Object)a);
    }

    @Transactional(value="defaultTransactionManager")
    public List<AuthenticationHolderEntity> getOrphanedAuthenticationHolders() {
        DefaultPageCriteria pageCriteria = new DefaultPageCriteria(0, 1000);
        return this.getOrphanedAuthenticationHolders((PageCriteria)pageCriteria);
    }

    @Transactional(value="defaultTransactionManager")
    public List<AuthenticationHolderEntity> getOrphanedAuthenticationHolders(PageCriteria pageCriteria) {
        TypedQuery query = this.manager.createNamedQuery("AuthenticationHolderEntity.getUnusedAuthenticationHolders", AuthenticationHolderEntity.class);
        return JpaUtil.getResultPage((TypedQuery)query, (PageCriteria)pageCriteria);
    }
}

