/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.web;

import com.google.common.collect.ImmutableList;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.mitre.openid.connect.config.ConfigurationPropertiesBean;
import org.mitre.openid.connect.service.MITREidDataService;
import org.mitre.openid.connect.service.impl.MITREidDataService_1_3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/api/data"})
@PreAuthorize(value="hasRole('ROLE_ADMIN')")
public class DataAPI {
    public static final String URL = "api/data";
    private static final Logger logger = LoggerFactory.getLogger(DataAPI.class);
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    @Autowired
    private ConfigurationPropertiesBean config;
    @Autowired
    private List<MITREidDataService> importers;
    private List<String> supportedVersions = ImmutableList.of((Object)"mitreid-connect-1.0", (Object)"mitreid-connect-1.1", (Object)"mitreid-connect-1.2", (Object)"mitreid-connect-1.3");
    @Autowired
    private MITREidDataService_1_3 exporter;

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"})
    public String importData(Reader in, Model m) throws IOException {
        JsonReader reader = new JsonReader(in);
        reader.beginObject();
        block4: while (reader.hasNext()) {
            JsonToken tok = reader.peek();
            block0 : switch (tok) {
                case NAME: {
                    String name = reader.nextName();
                    if (this.supportedVersions.contains(name)) {
                        for (MITREidDataService dataService : this.importers) {
                            if (!dataService.supportsVersion(name)) continue;
                            dataService.importData(reader);
                            break block0;
                        }
                        continue block4;
                    }
                    logger.debug("Skipping value for " + name);
                    reader.skipValue();
                    break;
                }
                case END_OBJECT: {
                    break;
                }
            }
        }
        reader.endObject();
        return "httpCodeView";
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    public void exportData(HttpServletResponse resp, Principal prin) throws IOException {
        resp.setContentType("application/json");
        JsonWriter writer = new JsonWriter((Writer)resp.getWriter());
        writer.setIndent("  ");
        try {
            writer.beginObject();
            writer.name("exported-at");
            writer.value(this.dateFormat.format(new Date()));
            writer.name("exported-from");
            writer.value(this.config.getIssuer());
            writer.name("exported-by");
            writer.value(prin.getName());
            this.exporter.exportData(writer);
            writer.endObject();
            writer.close();
        }
        catch (IOException e) {
            logger.error("Unable to export data", (Throwable)e);
        }
    }
}

