/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.uma.repository.impl;

import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.mitre.uma.model.ResourceSet;
import org.mitre.uma.repository.ResourceSetRepository;
import org.mitre.util.jpa.JpaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JpaResourceSetRepository
implements ResourceSetRepository {
    @PersistenceContext(unitName="defaultPersistenceUnit")
    private EntityManager em;
    private static Logger logger = LoggerFactory.getLogger(JpaResourceSetRepository.class);

    @Transactional(value="defaultTransactionManager")
    public ResourceSet save(ResourceSet rs) {
        return (ResourceSet)JpaUtil.saveOrUpdate((Object)rs.getId(), (EntityManager)this.em, (Object)rs);
    }

    public ResourceSet getById(Long id) {
        return (ResourceSet)this.em.find(ResourceSet.class, (Object)id);
    }

    @Transactional(value="defaultTransactionManager")
    public void remove(ResourceSet rs) {
        ResourceSet found = this.getById(rs.getId());
        if (found != null) {
            this.em.remove((Object)found);
        } else {
            logger.info("Tried to remove unknown resource set: " + rs.getId());
        }
    }

    public Collection<ResourceSet> getAllForOwner(String owner) {
        TypedQuery query = this.em.createNamedQuery("ResourceSet.queryByOwner", ResourceSet.class);
        query.setParameter("owner", (Object)owner);
        return query.getResultList();
    }

    public Collection<ResourceSet> getAllForOwnerAndClient(String owner, String clientId) {
        TypedQuery query = this.em.createNamedQuery("ResourceSet.queryByOwnerAndClient", ResourceSet.class);
        query.setParameter("owner", (Object)owner);
        query.setParameter("clientId", (Object)clientId);
        return query.getResultList();
    }

    public Collection<ResourceSet> getAll() {
        TypedQuery query = this.em.createNamedQuery("ResourceSet.queryAll", ResourceSet.class);
        return query.getResultList();
    }

    public Collection<ResourceSet> getAllForClient(String clientId) {
        TypedQuery query = this.em.createNamedQuery("ResourceSet.queryByClient", ResourceSet.class);
        query.setParameter("clientId", (Object)clientId);
        return query.getResultList();
    }
}

