/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.service.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.mitre.jwt.encryption.service.JWTEncryptionAndDecryptionService;
import org.mitre.jwt.signer.service.JWTSigningAndValidationService;
import org.mitre.jwt.signer.service.impl.ClientKeyCacheService;
import org.mitre.jwt.signer.service.impl.SymmetricKeyJWTValidatorCacheService;
import org.mitre.oauth2.model.AuthenticationHolderEntity;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.repository.AuthenticationHolderRepository;
import org.mitre.oauth2.service.OAuth2TokenEntityService;
import org.mitre.openid.connect.config.ConfigurationPropertiesBean;
import org.mitre.openid.connect.service.OIDCTokenService;
import org.mitre.openid.connect.util.IdTokenHashUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.stereotype.Service;

@Service
public class DefaultOIDCTokenService
implements OIDCTokenService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultOIDCTokenService.class);
    @Autowired
    private JWTSigningAndValidationService jwtService;
    @Autowired
    private AuthenticationHolderRepository authenticationHolderRepository;
    @Autowired
    private ConfigurationPropertiesBean configBean;
    @Autowired
    private ClientKeyCacheService encrypters;
    @Autowired
    private SymmetricKeyJWTValidatorCacheService symmetricCacheService;
    @Autowired
    private OAuth2TokenEntityService tokenService;

    public JWT createIdToken(ClientDetailsEntity client, OAuth2Request request, Date issueTime, String sub, OAuth2AccessTokenEntity accessToken) {
        JWSHeader header;
        Set responseTypes;
        JWSAlgorithm signingAlg = this.jwtService.getDefaultSigningAlgorithm();
        if (client.getIdTokenSignedResponseAlg() != null) {
            signingAlg = client.getIdTokenSignedResponseAlg();
        }
        PlainJWT idToken = null;
        JWTClaimsSet.Builder idClaims = new JWTClaimsSet.Builder();
        if (request.getExtensions().containsKey("max_age") || request.getExtensions().containsKey("idtoken") || client.getRequireAuthTime() != null && client.getRequireAuthTime().booleanValue()) {
            if (request.getExtensions().get("AUTH_TIMESTAMP") != null) {
                Long authTimestamp = Long.parseLong((String)request.getExtensions().get("AUTH_TIMESTAMP"));
                if (authTimestamp != null) {
                    idClaims.claim("auth_time", (Object)(authTimestamp / 1000L));
                }
            } else {
                logger.warn("Unable to find authentication timestamp! There is likely something wrong with the configuration.");
            }
        }
        idClaims.issueTime(issueTime);
        if (client.getIdTokenValiditySeconds() != null) {
            Date expiration = new Date(System.currentTimeMillis() + (long)client.getIdTokenValiditySeconds().intValue() * 1000L);
            idClaims.expirationTime(expiration);
        }
        idClaims.issuer(this.configBean.getIssuer());
        idClaims.subject(sub);
        idClaims.audience((List)Lists.newArrayList((Object[])new String[]{client.getClientId()}));
        idClaims.jwtID(UUID.randomUUID().toString());
        String nonce = (String)request.getExtensions().get("nonce");
        if (!Strings.isNullOrEmpty((String)nonce)) {
            idClaims.claim("nonce", (Object)nonce);
        }
        if ((responseTypes = request.getResponseTypes()).contains("token")) {
            Base64URL at_hash = IdTokenHashUtils.getAccessTokenHash(signingAlg, accessToken);
            idClaims.claim("at_hash", (Object)at_hash);
        }
        this.addCustomIdTokenClaims(idClaims, client, request, sub, accessToken);
        if (!(client.getIdTokenEncryptedResponseAlg() == null || client.getIdTokenEncryptedResponseAlg().equals((Object)Algorithm.NONE) || client.getIdTokenEncryptedResponseEnc() == null || client.getIdTokenEncryptedResponseEnc().equals((Object)Algorithm.NONE) || Strings.isNullOrEmpty((String)client.getJwksUri()) && client.getJwks() == null)) {
            JWTEncryptionAndDecryptionService encrypter = this.encrypters.getEncrypter(client);
            if (encrypter != null) {
                idToken = new EncryptedJWT(new JWEHeader(client.getIdTokenEncryptedResponseAlg(), client.getIdTokenEncryptedResponseEnc()), idClaims.build());
                encrypter.encryptJwt((JWEObject)idToken);
            } else {
                logger.error("Couldn't find encrypter for client: " + client.getClientId());
            }
        } else if (signingAlg.equals((Object)Algorithm.NONE)) {
            idToken = new PlainJWT(idClaims.build());
        } else if (signingAlg.equals((Object)JWSAlgorithm.HS256) || signingAlg.equals((Object)JWSAlgorithm.HS384) || signingAlg.equals((Object)JWSAlgorithm.HS512)) {
            header = new JWSHeader(signingAlg, null, null, null, null, null, null, null, null, null, this.jwtService.getDefaultSignerKeyId(), null, null);
            idToken = new SignedJWT(header, idClaims.build());
            JWTSigningAndValidationService signer = this.symmetricCacheService.getSymmetricValidtor(client);
            signer.signJwt((SignedJWT)idToken);
        } else {
            idClaims.claim("kid", (Object)this.jwtService.getDefaultSignerKeyId());
            header = new JWSHeader(signingAlg, null, null, null, null, null, null, null, null, null, this.jwtService.getDefaultSignerKeyId(), null, null);
            idToken = new SignedJWT(header, idClaims.build());
            this.jwtService.signJwt((SignedJWT)idToken);
        }
        return idToken;
    }

    public OAuth2AccessTokenEntity createRegistrationAccessToken(ClientDetailsEntity client) {
        return this.createAssociatedToken(client, Sets.newHashSet((Object[])new String[]{"registration-token"}));
    }

    public OAuth2AccessTokenEntity createResourceAccessToken(ClientDetailsEntity client) {
        return this.createAssociatedToken(client, Sets.newHashSet((Object[])new String[]{"resource-token"}));
    }

    public OAuth2AccessTokenEntity rotateRegistrationAccessTokenForClient(ClientDetailsEntity client) {
        OAuth2AccessTokenEntity oldToken = this.tokenService.getRegistrationAccessTokenForClient(client);
        if (oldToken != null) {
            Set scope = oldToken.getScope();
            this.tokenService.revokeAccessToken(oldToken);
            return this.createAssociatedToken(client, scope);
        }
        return null;
    }

    private OAuth2AccessTokenEntity createAssociatedToken(ClientDetailsEntity client, Set<String> scope) {
        OAuth2AccessTokenEntity oldToken = this.tokenService.getRegistrationAccessTokenForClient(client);
        if (oldToken != null) {
            this.tokenService.revokeAccessToken(oldToken);
        }
        HashMap authorizationParameters = Maps.newHashMap();
        OAuth2Request clientAuth = new OAuth2Request((Map)authorizationParameters, client.getClientId(), (Collection)Sets.newHashSet((Object[])new SimpleGrantedAuthority[]{new SimpleGrantedAuthority("ROLE_CLIENT")}), true, scope, null, null, null, null);
        OAuth2Authentication authentication = new OAuth2Authentication(clientAuth, null);
        OAuth2AccessTokenEntity token = new OAuth2AccessTokenEntity();
        token.setClient(client);
        token.setScope(scope);
        AuthenticationHolderEntity authHolder = new AuthenticationHolderEntity();
        authHolder.setAuthentication(authentication);
        authHolder = this.authenticationHolderRepository.save(authHolder);
        token.setAuthenticationHolder(authHolder);
        JWTClaimsSet claims = new JWTClaimsSet.Builder().audience((List)Lists.newArrayList((Object[])new String[]{client.getClientId()})).issuer(this.configBean.getIssuer()).issueTime(new Date()).expirationTime(token.getExpiration()).jwtID(UUID.randomUUID().toString()).build();
        JWSAlgorithm signingAlg = this.jwtService.getDefaultSigningAlgorithm();
        JWSHeader header = new JWSHeader(signingAlg, null, null, null, null, null, null, null, null, null, this.jwtService.getDefaultSignerKeyId(), null, null);
        SignedJWT signed = new SignedJWT(header, claims);
        this.jwtService.signJwt(signed);
        token.setJwt((JWT)signed);
        return token;
    }

    public ConfigurationPropertiesBean getConfigBean() {
        return this.configBean;
    }

    public void setConfigBean(ConfigurationPropertiesBean configBean) {
        this.configBean = configBean;
    }

    public JWTSigningAndValidationService getJwtService() {
        return this.jwtService;
    }

    public void setJwtService(JWTSigningAndValidationService jwtService) {
        this.jwtService = jwtService;
    }

    public AuthenticationHolderRepository getAuthenticationHolderRepository() {
        return this.authenticationHolderRepository;
    }

    public void setAuthenticationHolderRepository(AuthenticationHolderRepository authenticationHolderRepository) {
        this.authenticationHolderRepository = authenticationHolderRepository;
    }

    protected void addCustomIdTokenClaims(JWTClaimsSet.Builder idClaims, ClientDetailsEntity client, OAuth2Request request, String sub, OAuth2AccessTokenEntity accessToken) {
    }
}

