/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.uma.service.impl;

import java.util.Collection;
import java.util.Set;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.repository.OAuth2TokenRepository;
import org.mitre.uma.model.PermissionTicket;
import org.mitre.uma.model.Policy;
import org.mitre.uma.model.ResourceSet;
import org.mitre.uma.repository.PermissionRepository;
import org.mitre.uma.repository.ResourceSetRepository;
import org.mitre.uma.service.ResourceSetService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class DefaultResourceSetService
implements ResourceSetService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultResourceSetService.class);
    @Autowired
    private ResourceSetRepository repository;
    @Autowired
    private OAuth2TokenRepository tokenRepository;
    @Autowired
    private PermissionRepository ticketRepository;

    public ResourceSet saveNew(ResourceSet rs) {
        if (rs.getId() != null) {
            throw new IllegalArgumentException("Can't save a new resource set with an ID already set to it.");
        }
        if (!this.checkScopeConsistency(rs)) {
            throw new IllegalArgumentException("Can't save a resource set with inconsistent claims.");
        }
        ResourceSet saved = this.repository.save(rs);
        return saved;
    }

    public ResourceSet getById(Long id) {
        return this.repository.getById(id);
    }

    public ResourceSet update(ResourceSet oldRs, ResourceSet newRs) {
        if (oldRs.getId() == null || newRs.getId() == null || !oldRs.getId().equals(newRs.getId())) {
            throw new IllegalArgumentException("Resource set IDs mismatched");
        }
        if (!this.checkScopeConsistency(newRs)) {
            throw new IllegalArgumentException("Can't save a resource set with inconsistent claims.");
        }
        newRs.setOwner(oldRs.getOwner());
        newRs.setClientId(oldRs.getClientId());
        ResourceSet saved = this.repository.save(newRs);
        return saved;
    }

    public void remove(ResourceSet rs) {
        Set tokens = this.tokenRepository.getAccessTokensForResourceSet(rs);
        for (OAuth2AccessTokenEntity token : tokens) {
            this.tokenRepository.removeAccessToken(token);
        }
        Collection tickets = this.ticketRepository.getPermissionTicketsForResourceSet(rs);
        for (PermissionTicket ticket : tickets) {
            this.ticketRepository.remove(ticket);
        }
        this.repository.remove(rs);
    }

    public Collection<ResourceSet> getAllForOwner(String owner) {
        return this.repository.getAllForOwner(owner);
    }

    public Collection<ResourceSet> getAllForOwnerAndClient(String owner, String clientId) {
        return this.repository.getAllForOwnerAndClient(owner, clientId);
    }

    private boolean checkScopeConsistency(ResourceSet rs) {
        if (rs.getPolicies() == null) {
            return true;
        }
        for (Policy policy : rs.getPolicies()) {
            if (rs.getScopes().containsAll(policy.getScopes())) continue;
            return false;
        }
        return true;
    }

    public Collection<ResourceSet> getAllForClient(ClientDetailsEntity client) {
        return this.repository.getAllForClient(client.getClientId());
    }
}

