/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.uma.web;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.util.Collection;
import java.util.HashSet;
import org.mitre.uma.model.Claim;
import org.mitre.uma.model.Policy;
import org.mitre.uma.model.ResourceSet;
import org.mitre.uma.service.ResourceSetService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/api/resourceset"})
@PreAuthorize(value="hasRole('ROLE_USER')")
public class PolicyAPI {
    private static final Logger logger = LoggerFactory.getLogger(PolicyAPI.class);
    public static final String URL = "api/resourceset";
    public static final String POLICYURL = "/policy";
    private Gson gson = new Gson();
    @Autowired
    private ResourceSetService resourceSetService;

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    public String getResourceSetsForCurrentUser(Model m, Authentication auth) {
        Collection resourceSets = this.resourceSetService.getAllForOwner(auth.getName());
        m.addAttribute("entity", (Object)resourceSets);
        return "jsonEntityView";
    }

    @RequestMapping(value={"/{rsid}"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getResourceSet(@PathVariable(value="rsid") Long rsid, Model m, Authentication auth) {
        ResourceSet rs = this.resourceSetService.getById(rsid);
        if (rs == null) {
            m.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
            return "httpCodeView";
        }
        if (!rs.getOwner().equals(auth.getName())) {
            logger.warn("Unauthorized resource set request from bad user; expected " + rs.getOwner() + " got " + auth.getName());
            m.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
            return "httpCodeView";
        }
        m.addAttribute("entity", (Object)rs);
        return "jsonEntityView";
    }

    @RequestMapping(value={"/{rsid}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    public String deleteResourceSet(@PathVariable(value="rsid") Long rsid, Model m, Authentication auth) {
        ResourceSet rs = this.resourceSetService.getById(rsid);
        if (rs == null) {
            m.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
            return "httpCodeView";
        }
        if (!rs.getOwner().equals(auth.getName())) {
            logger.warn("Unauthorized resource set request from bad user; expected " + rs.getOwner() + " got " + auth.getName());
            m.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
            return "httpCodeView";
        }
        this.resourceSetService.remove(rs);
        m.addAttribute("code", (Object)HttpStatus.NO_CONTENT);
        return "httpCodeView";
    }

    @RequestMapping(value={"/{rsid}/policy"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getPoliciesForResourceSet(@PathVariable(value="rsid") Long rsid, Model m, Authentication auth) {
        ResourceSet rs = this.resourceSetService.getById(rsid);
        if (rs == null) {
            m.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
            return "httpCodeView";
        }
        if (!rs.getOwner().equals(auth.getName())) {
            logger.warn("Unauthorized resource set request from bad user; expected " + rs.getOwner() + " got " + auth.getName());
            m.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
            return "httpCodeView";
        }
        m.addAttribute("entity", (Object)rs.getPolicies());
        return "jsonEntityView";
    }

    @RequestMapping(value={"/{rsid}/policy"}, method={RequestMethod.POST}, produces={"application/json"})
    public String createNewPolicyForResourceSet(@PathVariable(value="rsid") Long rsid, @RequestBody String jsonString, Model m, Authentication auth) {
        ResourceSet rs = this.resourceSetService.getById(rsid);
        if (rs == null) {
            m.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
            return "httpCodeView";
        }
        if (!rs.getOwner().equals(auth.getName())) {
            logger.warn("Unauthorized resource set request from bad user; expected " + rs.getOwner() + " got " + auth.getName());
            m.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
            return "httpCodeView";
        }
        Policy p = (Policy)this.gson.fromJson(jsonString, Policy.class);
        if (p.getId() != null) {
            logger.warn("Tried to add a policy with a non-null ID: " + p.getId());
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            return "httpCodeView";
        }
        for (Claim claim : p.getClaimsRequired()) {
            if (claim.getId() == null) continue;
            logger.warn("Tried to add a policy with a non-null claim ID: " + claim.getId());
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            return "httpCodeView";
        }
        rs.getPolicies().add(p);
        ResourceSet saved = this.resourceSetService.update(rs, rs);
        Sets.SetView newPolicies = Sets.difference(new HashSet(saved.getPolicies()), new HashSet(rs.getPolicies()));
        if (newPolicies.size() == 1) {
            Policy newPolicy = (Policy)newPolicies.iterator().next();
            m.addAttribute("entity", (Object)newPolicy);
            return "jsonEntityView";
        }
        logger.warn("Unexpected result trying to add a new policy object: " + newPolicies);
        m.addAttribute("code", (Object)HttpStatus.INTERNAL_SERVER_ERROR);
        return "httpCodeView";
    }

    @RequestMapping(value={"/{rsid}/policy/{pid}"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getPolicy(@PathVariable(value="rsid") Long rsid, @PathVariable(value="pid") Long pid, Model m, Authentication auth) {
        ResourceSet rs = this.resourceSetService.getById(rsid);
        if (rs == null) {
            m.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
            return "httpCodeView";
        }
        if (!rs.getOwner().equals(auth.getName())) {
            logger.warn("Unauthorized resource set request from bad user; expected " + rs.getOwner() + " got " + auth.getName());
            m.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
            return "httpCodeView";
        }
        for (Policy policy : rs.getPolicies()) {
            if (!policy.getId().equals(pid)) continue;
            m.addAttribute("entity", (Object)policy);
            return "jsonEntityView";
        }
        m.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
        return "httpCodeView";
    }

    @RequestMapping(value={"/{rsid}/policy/{pid}"}, method={RequestMethod.PUT}, consumes={"application/json"}, produces={"application/json"})
    public String setClaimsForResourceSet(@PathVariable(value="rsid") Long rsid, @PathVariable(value="pid") Long pid, @RequestBody String jsonString, Model m, Authentication auth) {
        ResourceSet rs = this.resourceSetService.getById(rsid);
        if (rs == null) {
            m.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
            return "httpCodeView";
        }
        if (!rs.getOwner().equals(auth.getName())) {
            logger.warn("Unauthorized resource set request from bad user; expected " + rs.getOwner() + " got " + auth.getName());
            m.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
            return "httpCodeView";
        }
        Policy p = (Policy)this.gson.fromJson(jsonString, Policy.class);
        if (!pid.equals(p.getId())) {
            logger.warn("Policy ID mismatch, expected " + pid + " got " + p.getId());
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            return "httpCodeView";
        }
        for (Policy policy : rs.getPolicies()) {
            if (!policy.getId().equals(pid)) continue;
            HashSet<Long> claimIds = new HashSet<Long>();
            for (Claim claim : policy.getClaimsRequired()) {
                claimIds.add(claim.getId());
            }
            for (Claim claim : p.getClaimsRequired()) {
                if (claim.getId() == null || claimIds.contains(claim.getId())) continue;
                logger.warn("Tried to add a policy with a an unmatched claim ID: got " + claim.getId() + " expected " + claimIds);
                m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
                return "httpCodeView";
            }
            policy.setClaimsRequired(p.getClaimsRequired());
            policy.setName(p.getName());
            policy.setScopes(p.getScopes());
            this.resourceSetService.update(rs, rs);
            m.addAttribute("entity", (Object)policy);
            return "jsonEntityView";
        }
        m.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
        return "httpCodeView";
    }

    @RequestMapping(value={"/{rsid}/policy/{pid}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    public String deleteResourceSet(@PathVariable(value="rsid") Long rsid, @PathVariable(value="pid") Long pid, Model m, Authentication auth) {
        ResourceSet rs = this.resourceSetService.getById(rsid);
        if (rs == null) {
            m.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
            m.addAttribute("error", (Object)"not_found");
            return "jsonErrorView";
        }
        if (!auth.getName().equals(rs.getOwner())) {
            logger.warn("Unauthorized resource set request from bad user; expected " + rs.getOwner() + " got " + auth.getName());
            m.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
            return "jsonErrorView";
        }
        for (Policy policy : rs.getPolicies()) {
            if (!policy.getId().equals(pid)) continue;
            rs.getPolicies().remove(policy);
            this.resourceSetService.update(rs, rs);
            m.addAttribute("code", (Object)HttpStatus.NO_CONTENT);
            return "httpCodeView";
        }
        m.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
        return "httpCodeView";
    }
}

