/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.uma.service.impl;

import java.util.Collection;
import java.util.HashSet;
import org.mitre.uma.model.Claim;
import org.mitre.uma.model.ClaimProcessingResult;
import org.mitre.uma.model.PermissionTicket;
import org.mitre.uma.model.Policy;
import org.mitre.uma.model.ResourceSet;
import org.mitre.uma.service.ClaimsProcessingService;
import org.springframework.stereotype.Service;

@Service(value="matchAllClaimsOnAnyPolicy")
public class MatchAllClaimsOnAnyPolicy
implements ClaimsProcessingService {
    public ClaimProcessingResult claimsAreSatisfied(ResourceSet rs, PermissionTicket ticket) {
        HashSet<Claim> allUnmatched = new HashSet<Claim>();
        for (Policy policy : rs.getPolicies()) {
            Collection<Claim> unmatched = this.checkIndividualClaims(policy.getClaimsRequired(), ticket.getClaimsSupplied());
            if (unmatched.isEmpty()) {
                return new ClaimProcessingResult(policy);
            }
            allUnmatched.addAll(unmatched);
        }
        return new ClaimProcessingResult(allUnmatched);
    }

    private Collection<Claim> checkIndividualClaims(Collection<Claim> claimsRequired, Collection<Claim> claimsSupplied) {
        HashSet<Claim> claimsUnmatched = new HashSet<Claim>(claimsRequired);
        for (Claim required : claimsRequired) {
            for (Claim supplied : claimsSupplied) {
                if (!required.getIssuer().containsAll(supplied.getIssuer()) || !required.getName().equals(supplied.getName()) || !required.getValue().equals(supplied.getValue())) continue;
                claimsUnmatched.remove(required);
            }
        }
        return claimsUnmatched;
    }
}

