/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.model;

import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.mitre.oauth2.model.AuthenticationHolderEntity;

@Entity
@Table(name="authorization_code")
@NamedQueries(value={@NamedQuery(name="AuthorizationCodeEntity.getByValue", query="select a from AuthorizationCodeEntity a where a.code = :code"), @NamedQuery(name="AuthorizationCodeEntity.expirationByDate", query="select a from AuthorizationCodeEntity a where a.expiration <= :date")})
public class AuthorizationCodeEntity {
    public static final String QUERY_BY_VALUE = "AuthorizationCodeEntity.getByValue";
    public static final String QUERY_EXPIRATION_BY_DATE = "AuthorizationCodeEntity.expirationByDate";
    public static final String PARAM_DATE = "date";
    private Long id;
    private String code;
    private AuthenticationHolderEntity authenticationHolder;
    private Date expiration;

    public AuthorizationCodeEntity() {
    }

    public AuthorizationCodeEntity(String code, AuthenticationHolderEntity authenticationHolder, Date expiration) {
        this.code = code;
        this.authenticationHolder = authenticationHolder;
        this.expiration = expiration;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Basic
    @Column(name="code")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @ManyToOne
    @JoinColumn(name="auth_holder_id")
    public AuthenticationHolderEntity getAuthenticationHolder() {
        return this.authenticationHolder;
    }

    public void setAuthenticationHolder(AuthenticationHolderEntity authenticationHolder) {
        this.authenticationHolder = authenticationHolder;
    }

    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="expiration")
    public Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }
}

