/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.uma.model;

import com.google.gson.JsonElement;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Table;
import org.mitre.oauth2.model.convert.JsonElementStringConverter;

@Entity
@Table(name="claim")
public class Claim {
    private Long id;
    private String name;
    private String friendlyName;
    private String claimType;
    private JsonElement value;
    private Set<String> claimTokenFormat;
    private Set<String> issuer;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Basic
    @Column(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Basic
    @Column(name="friendly_name")
    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    @Basic
    @Column(name="claim_type")
    public String getClaimType() {
        return this.claimType;
    }

    public void setClaimType(String claimType) {
        this.claimType = claimType;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @Column(name="claim_token_format")
    @CollectionTable(name="claim_token_format", joinColumns={@JoinColumn(name="owner_id")})
    public Set<String> getClaimTokenFormat() {
        return this.claimTokenFormat;
    }

    public void setClaimTokenFormat(Set<String> claimTokenFormat) {
        this.claimTokenFormat = claimTokenFormat;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @Column(name="issuer")
    @CollectionTable(name="claim_issuer", joinColumns={@JoinColumn(name="owner_id")})
    public Set<String> getIssuer() {
        return this.issuer;
    }

    public void setIssuer(Set<String> issuer) {
        this.issuer = issuer;
    }

    @Basic
    @Column(name="claim_value")
    @Convert(converter=JsonElementStringConverter.class)
    public JsonElement getValue() {
        return this.value;
    }

    public void setValue(JsonElement value) {
        this.value = value;
    }

    public String toString() {
        return "Claim [id=" + this.id + ", name=" + this.name + ", friendlyName=" + this.friendlyName + ", claimType=" + this.claimType + ", value=" + this.value + ", claimTokenFormat=" + this.claimTokenFormat + ", issuer=" + this.issuer + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.claimTokenFormat == null ? 0 : this.claimTokenFormat.hashCode());
        result = 31 * result + (this.claimType == null ? 0 : this.claimType.hashCode());
        result = 31 * result + (this.friendlyName == null ? 0 : this.friendlyName.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.issuer == null ? 0 : this.issuer.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Claim other = (Claim)obj;
        if (this.claimTokenFormat == null ? other.claimTokenFormat != null : !this.claimTokenFormat.equals(other.claimTokenFormat)) {
            return false;
        }
        if (this.claimType == null ? other.claimType != null : !this.claimType.equals(other.claimType)) {
            return false;
        }
        if (this.friendlyName == null ? other.friendlyName != null : !this.friendlyName.equals(other.friendlyName)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.issuer == null ? other.issuer != null : !this.issuer.equals(other.issuer)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

