/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.web;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import java.text.ParseException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.mitre.jwt.assertion.impl.SelfAssertionValidator;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.openid.connect.model.UserInfo;
import org.mitre.openid.connect.service.UserInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
public class EndSessionEndpoint {
    public static final String URL = "endsession";
    private static final String CLIENT_KEY = "client";
    private static final String STATE_KEY = "state";
    private static final String REDIRECT_URI_KEY = "redirectUri";
    private static Logger logger = LoggerFactory.getLogger(EndSessionEndpoint.class);
    @Autowired
    private SelfAssertionValidator validator;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private ClientDetailsEntityService clientService;

    @RequestMapping(value={"/endsession"}, method={RequestMethod.GET})
    public String endSession(@RequestParam(value="id_token_hint", required=false) String idTokenHint, @RequestParam(value="post_logout_redirect_uri", required=false) String postLogoutRedirectUri, @RequestParam(value="state", required=false) String state, HttpServletRequest request, HttpServletResponse response, HttpSession session, Authentication auth, Model m) {
        String subject;
        JWTClaimsSet idTokenClaims = null;
        ClientDetailsEntity client = null;
        if (!Strings.isNullOrEmpty((String)postLogoutRedirectUri)) {
            session.setAttribute(REDIRECT_URI_KEY, (Object)postLogoutRedirectUri);
        }
        if (!Strings.isNullOrEmpty((String)state)) {
            session.setAttribute(STATE_KEY, (Object)state);
        }
        if (!Strings.isNullOrEmpty((String)idTokenHint)) {
            try {
                JWT idToken = JWTParser.parse((String)idTokenHint);
                if (this.validator.isValid(idToken)) {
                    idTokenClaims = idToken.getJWTClaimsSet();
                    String clientId = (String)Iterables.getOnlyElement((Iterable)idTokenClaims.getAudience());
                    client = this.clientService.loadClientByClientId(clientId);
                    session.setAttribute(CLIENT_KEY, (Object)client);
                }
            }
            catch (ParseException e) {
                logger.debug("Invalid id token hint", (Throwable)e);
            }
            catch (InvalidClientException e) {
                logger.debug("Invalid client", (Throwable)e);
            }
        }
        if (auth == null || !request.isUserInRole("ROLE_USER")) {
            return this.processLogout(null, request, response, session, auth, m);
        }
        UserInfo ui = this.userInfoService.getByUsername(auth.getName());
        if (idTokenClaims == null || Strings.isNullOrEmpty((String)(subject = idTokenClaims.getSubject())) || subject.equals(ui.getSub())) {
            // empty if block
        }
        m.addAttribute(CLIENT_KEY, client);
        m.addAttribute("idToken", (Object)idTokenClaims);
        return "logoutConfirmation";
    }

    @RequestMapping(value={"/endsession"}, method={RequestMethod.POST})
    public String processLogout(@RequestParam(value="approve", required=false) String approved, HttpServletRequest request, HttpServletResponse response, HttpSession session, Authentication auth, Model m) {
        String redirectUri = (String)session.getAttribute(REDIRECT_URI_KEY);
        String state = (String)session.getAttribute(STATE_KEY);
        ClientDetailsEntity client = (ClientDetailsEntity)session.getAttribute(CLIENT_KEY);
        if (!Strings.isNullOrEmpty((String)approved)) {
            if (auth != null) {
                new SecurityContextLogoutHandler().logout(request, response, auth);
            }
            SecurityContextHolder.getContext().setAuthentication(null);
        }
        if (!Strings.isNullOrEmpty((String)redirectUri) && client != null && client.getPostLogoutRedirectUris() != null && client.getPostLogoutRedirectUris().contains(redirectUri)) {
            UriComponents uri = UriComponentsBuilder.fromHttpUrl((String)redirectUri).queryParam(STATE_KEY, new Object[]{state}).build();
            return "redirect:" + uri;
        }
        return "postLogout";
    }
}

