/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.expression;

import java.util.Collection;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.expression.ExpressionUtils;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.DefaultWebSecurityExpressionHandler;
import org.springframework.security.web.access.expression.WebExpressionConfigAttribute;

public class WebExpressionVoter
implements AccessDecisionVoter<FilterInvocation> {
    private SecurityExpressionHandler<FilterInvocation> expressionHandler = new DefaultWebSecurityExpressionHandler();

    public int vote(Authentication authentication, FilterInvocation fi, Collection<ConfigAttribute> attributes) {
        assert (authentication != null);
        assert (fi != null);
        assert (attributes != null);
        WebExpressionConfigAttribute weca = this.findConfigAttribute(attributes);
        if (weca == null) {
            return 0;
        }
        EvaluationContext ctx = this.expressionHandler.createEvaluationContext(authentication, (Object)fi);
        ctx = weca.postProcess(ctx, fi);
        return ExpressionUtils.evaluateAsBoolean((Expression)weca.getAuthorizeExpression(), (EvaluationContext)ctx) ? 1 : -1;
    }

    private WebExpressionConfigAttribute findConfigAttribute(Collection<ConfigAttribute> attributes) {
        for (ConfigAttribute attribute : attributes) {
            if (!(attribute instanceof WebExpressionConfigAttribute)) continue;
            return (WebExpressionConfigAttribute)attribute;
        }
        return null;
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute instanceof WebExpressionConfigAttribute;
    }

    public boolean supports(Class<?> clazz) {
        return FilterInvocation.class.isAssignableFrom(clazz);
    }

    public void setExpressionHandler(SecurityExpressionHandler<FilterInvocation> expressionHandler) {
        this.expressionHandler = expressionHandler;
    }
}

