/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.uma.web;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.service.OAuth2TokenEntityService;
import org.mitre.oauth2.web.AuthenticationUtilities;
import org.mitre.uma.model.Claim;
import org.mitre.uma.model.ClaimProcessingResult;
import org.mitre.uma.model.PermissionTicket;
import org.mitre.uma.model.ResourceSet;
import org.mitre.uma.service.ClaimsProcessingService;
import org.mitre.uma.service.PermissionService;
import org.mitre.uma.service.UmaTokenService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/authz_request"})
public class AuthorizationRequestEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationRequestEndpoint.class);
    public static final String RPT = "rpt";
    public static final String TICKET = "ticket";
    public static final String URL = "authz_request";
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private OAuth2TokenEntityService tokenService;
    @Autowired
    private ClaimsProcessingService claimsProcessingService;
    @Autowired
    private UmaTokenService umaTokenService;

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String authorizationRequest(@RequestBody String jsonString, Model m, Authentication auth) {
        AuthenticationUtilities.ensureOAuthScope((Authentication)auth, (String)"uma_authorization");
        JsonParser parser = new JsonParser();
        JsonElement e = parser.parse(jsonString);
        if (e.isJsonObject()) {
            JsonObject o = e.getAsJsonObject();
            if (o.has(TICKET)) {
                String ticketValue;
                PermissionTicket ticket;
                OAuth2AccessTokenEntity incomingRpt = null;
                if (o.has(RPT)) {
                    String rptValue = o.get(RPT).getAsString();
                    incomingRpt = this.tokenService.readAccessToken(rptValue);
                }
                if ((ticket = this.permissionService.getByTicket(ticketValue = o.get(TICKET).getAsString())) != null) {
                    ResourceSet rs = ticket.getPermission().getResourceSet();
                    if (rs.getPolicies() == null || rs.getPolicies().isEmpty()) {
                        m.addAttribute("error", (Object)"not_authorized");
                        m.addAttribute("errorMessage", (Object)"This resource set can not be accessed.");
                        m.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
                        return "jsonErrorView";
                    }
                    ClaimProcessingResult result = this.claimsProcessingService.claimsAreSatisfied(rs, ticket);
                    if (result.isSatisfied()) {
                        OAuth2Authentication o2auth = (OAuth2Authentication)auth;
                        OAuth2AccessTokenEntity token = this.umaTokenService.createRequestingPartyToken(o2auth, ticket, result.getMatched());
                        if (incomingRpt != null) {
                            this.tokenService.revokeAccessToken(incomingRpt);
                        }
                        ImmutableMap entity = ImmutableMap.of((Object)RPT, (Object)token.getValue());
                        m.addAttribute("entity", (Object)entity);
                        return "jsonEntityView";
                    }
                    JsonObject entity = new JsonObject();
                    entity.addProperty("error", "need_info");
                    JsonObject details = new JsonObject();
                    JsonObject rpClaims = new JsonObject();
                    rpClaims.addProperty("redirect_user", Boolean.valueOf(true));
                    rpClaims.addProperty(TICKET, ticketValue);
                    JsonArray req = new JsonArray();
                    for (Claim claim : result.getUnmatched()) {
                        JsonObject c = new JsonObject();
                        c.addProperty("name", claim.getName());
                        c.addProperty("friendly_name", claim.getFriendlyName());
                        c.addProperty("claim_type", claim.getClaimType());
                        JsonArray f = new JsonArray();
                        for (String format : claim.getClaimTokenFormat()) {
                            f.add((JsonElement)new JsonPrimitive(format));
                        }
                        c.add("claim_token_format", (JsonElement)f);
                        JsonArray i = new JsonArray();
                        for (String issuer : claim.getIssuer()) {
                            i.add((JsonElement)new JsonPrimitive(issuer));
                        }
                        c.add("issuer", (JsonElement)i);
                        req.add((JsonElement)c);
                    }
                    rpClaims.add("required_claims", (JsonElement)req);
                    details.add("requesting_party_claims", (JsonElement)rpClaims);
                    entity.add("error_details", (JsonElement)details);
                    m.addAttribute("entity", (Object)entity);
                    return "jsonEntityView";
                }
                m.addAttribute((Object)HttpStatus.BAD_REQUEST);
                m.addAttribute("error", (Object)"invalid_ticket");
                return "jsonErrorView";
            }
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            m.addAttribute("errorMessage", (Object)"Missing JSON elements.");
            return "jsonErrorView";
        }
        m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
        m.addAttribute("errorMessage", (Object)"Malformed JSON request.");
        return "jsonErrorView";
    }
}

