/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.service.impl;

import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.format.datetime.DateFormatter;

public abstract class MITREidDataServiceSupport {
    private final DateFormatter dateFormatter = new DateFormatter();
    private static final Logger logger = LoggerFactory.getLogger(MITREidDataServiceSupport.class);

    public MITREidDataServiceSupport() {
        this.dateFormatter.setIso(DateTimeFormat.ISO.DATE_TIME);
    }

    protected Date utcToDate(String value) {
        if (value == null) {
            return null;
        }
        try {
            return this.dateFormatter.parse(value, Locale.ENGLISH);
        }
        catch (ParseException ex) {
            logger.error("Unable to parse datetime {}", (Object)value, (Object)ex);
            return null;
        }
    }

    protected String toUTCString(Date value) {
        if (value == null) {
            return null;
        }
        return this.dateFormatter.print(value, Locale.ENGLISH);
    }
}

