/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.web;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.model.OAuth2RefreshTokenEntity;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.oauth2.service.IntrospectionResultAssembler;
import org.mitre.oauth2.service.OAuth2TokenEntityService;
import org.mitre.oauth2.web.AuthenticationUtilities;
import org.mitre.openid.connect.model.UserInfo;
import org.mitre.openid.connect.service.UserInfoService;
import org.mitre.uma.model.ResourceSet;
import org.mitre.uma.service.ResourceSetService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class IntrospectionEndpoint {
    public static final String URL = "introspect";
    @Autowired
    private OAuth2TokenEntityService tokenServices;
    @Autowired
    private ClientDetailsEntityService clientService;
    @Autowired
    private IntrospectionResultAssembler introspectionResultAssembler;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private ResourceSetService resourceSetService;
    private static final Logger logger = LoggerFactory.getLogger(IntrospectionEndpoint.class);

    public IntrospectionEndpoint() {
    }

    public IntrospectionEndpoint(OAuth2TokenEntityService tokenServices) {
        this.tokenServices = tokenServices;
    }

    @RequestMapping(value={"/introspect"})
    public String verify(@RequestParam(value="token") String tokenValue, @RequestParam(value="token_type_hint", required=false) String tokenType, Authentication auth, Model model) {
        Map entity;
        UserInfo user;
        ClientDetailsEntity tokenClient;
        ClientDetailsEntity authClient = null;
        HashSet authScopes = new HashSet();
        if (auth instanceof OAuth2Authentication) {
            AuthenticationUtilities.ensureOAuthScope(auth, "uma_protection");
            OAuth2Authentication o2a = (OAuth2Authentication)auth;
            String authClientId = o2a.getOAuth2Request().getClientId();
            authClient = this.clientService.loadClientByClientId(authClientId);
            String ownerId = o2a.getUserAuthentication().getName();
            authScopes.addAll(authClient.getScope());
            Collection resourceSets = this.resourceSetService.getAllForOwnerAndClient(ownerId, authClientId);
            for (ResourceSet rs : resourceSets) {
                authScopes.addAll(rs.getScopes());
            }
        } else {
            String authClientId = auth.getName();
            authClient = this.clientService.loadClientByClientId(authClientId);
            authScopes.addAll(authClient.getScope());
            if (!AuthenticationUtilities.hasRole(auth, "ROLE_CLIENT") || !authClient.isAllowIntrospection()) {
                logger.error("Client " + authClient.getClientId() + " is not allowed to call introspection endpoint");
                model.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
                return "httpCodeView";
            }
        }
        if (Strings.isNullOrEmpty((String)tokenValue)) {
            logger.error("Verify failed; token value is null");
            ImmutableMap entity2 = ImmutableMap.of((Object)"active", (Object)Boolean.FALSE);
            model.addAttribute("entity", (Object)entity2);
            return "jsonEntityView";
        }
        OAuth2AccessTokenEntity accessToken = null;
        OAuth2RefreshTokenEntity refreshToken = null;
        try {
            accessToken = this.tokenServices.readAccessToken(tokenValue);
            tokenClient = accessToken.getClient();
            String userName = accessToken.getAuthenticationHolder().getAuthentication().getName();
            user = this.userInfoService.getByUsernameAndClientId(userName, tokenClient.getClientId());
        }
        catch (InvalidTokenException e) {
            logger.info("Invalid access token. Checking refresh token.");
            try {
                refreshToken = this.tokenServices.getRefreshToken(tokenValue);
                tokenClient = refreshToken.getClient();
                String userName = refreshToken.getAuthenticationHolder().getAuthentication().getName();
                user = this.userInfoService.getByUsernameAndClientId(userName, tokenClient.getClientId());
            }
            catch (InvalidTokenException e2) {
                logger.error("Invalid refresh token");
                ImmutableMap entity3 = ImmutableMap.of((Object)"active", (Object)Boolean.FALSE);
                model.addAttribute("entity", (Object)entity3);
                return "jsonEntityView";
            }
        }
        if (accessToken != null) {
            entity = this.introspectionResultAssembler.assembleFrom(accessToken, user, authScopes);
            model.addAttribute("entity", (Object)entity);
        } else if (refreshToken != null) {
            entity = this.introspectionResultAssembler.assembleFrom(refreshToken, user, authScopes);
            model.addAttribute("entity", (Object)entity);
        } else {
            logger.error("Verify failed; Invalid access/refresh token");
            entity = ImmutableMap.of((Object)"active", (Object)Boolean.FALSE);
            model.addAttribute("entity", (Object)entity);
            return "jsonEntityView";
        }
        return "jsonEntityView";
    }
}

