/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.service.impl;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.openid.connect.model.CachedImage;
import org.mitre.openid.connect.service.ClientLogoLoadingService;
import org.springframework.stereotype.Service;

@Service(value="inMemoryClientLogoLoadingService")
public class InMemoryClientLogoLoadingService
implements ClientLogoLoadingService {
    private LoadingCache<ClientDetailsEntity, CachedImage> cache;

    public InMemoryClientLogoLoadingService() {
        this((HttpClient)HttpClientBuilder.create().useSystemProperties().build());
    }

    public InMemoryClientLogoLoadingService(HttpClient httpClient) {
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(14L, TimeUnit.DAYS).build((CacheLoader)new ClientLogoFetcher(httpClient));
    }

    public CachedImage getLogo(ClientDetailsEntity client) {
        try {
            if (client != null && !Strings.isNullOrEmpty((String)client.getLogoUri())) {
                return (CachedImage)this.cache.get((Object)client);
            }
            return null;
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            return null;
        }
    }

    public class ClientLogoFetcher
    extends CacheLoader<ClientDetailsEntity, CachedImage> {
        private HttpClient httpClient;

        public ClientLogoFetcher() {
            this((HttpClient)HttpClientBuilder.create().useSystemProperties().build());
        }

        public ClientLogoFetcher(HttpClient httpClient) {
            this.httpClient = httpClient;
        }

        public CachedImage load(ClientDetailsEntity key) throws Exception {
            try {
                HttpResponse response = this.httpClient.execute((HttpUriRequest)new HttpGet(key.getLogoUri()));
                HttpEntity entity = response.getEntity();
                CachedImage image = new CachedImage();
                image.setContentType(entity.getContentType().getValue());
                image.setLength(entity.getContentLength());
                image.setData(IOUtils.toByteArray((InputStream)entity.getContent()));
                return image;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to load client image.");
            }
        }
    }
}

