/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.uma.web;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import org.mitre.openid.connect.config.ConfigurationPropertiesBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class UmaDiscoveryEndpoint {
    @Autowired
    private ConfigurationPropertiesBean config;

    @RequestMapping(value={".well-known/uma-configuration"})
    public String umaConfiguration(Model model) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        String issuer = this.config.getIssuer();
        ImmutableSet tokenProfiles = ImmutableSet.of((Object)"bearer");
        ArrayList grantTypes = Lists.newArrayList((Object[])new String[]{"authorization_code", "implicit", "urn:ietf:params:oauth:grant-type:jwt-bearer", "client_credentials", "urn:ietf:params:oauth:grant_type:redelegate"});
        m.put("version", "1.0");
        m.put("issuer", issuer);
        m.put("pat_profiles_supported", tokenProfiles);
        m.put("aat_profiles_supported", tokenProfiles);
        m.put("rpt_profiles_supported", tokenProfiles);
        m.put("pat_grant_types_supported", grantTypes);
        m.put("aat_grant_types_supported", grantTypes);
        m.put("claim_token_profiles_supported", ImmutableSet.of());
        m.put("uma_profiles_supported", ImmutableSet.of());
        m.put("dynamic_client_endpoint", issuer + "register");
        m.put("token_endpoint", issuer + "token");
        m.put("authorization_endpoint", issuer + "authorize");
        m.put("requesting_party_claims_endpoint", issuer + "rqp_claims");
        m.put("introspection_endpoint", issuer + "introspect");
        m.put("resource_set_registration_endpoint", issuer + "resource_set");
        m.put("permission_registration_endpoint", issuer + "permission");
        m.put("rpt_endpoint", issuer + "authz_request");
        model.addAttribute("entity", m);
        return "jsonEntityView";
    }
}

