/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.discovery.util;

import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class WebfingerURLNormalizer {
    private static final Logger logger = LoggerFactory.getLogger(WebfingerURLNormalizer.class);
    private static final Pattern pattern = Pattern.compile("^((https|acct|http|mailto|tel|device):(//)?)?((([^@]+)@)?(([^\\?#:/]+)(:(\\d*))?))([^\\?#]+)?(\\?([^#]+))?(#(.*))?$");

    private WebfingerURLNormalizer() {
    }

    public static UriComponents normalizeResource(String identifier) {
        if (Strings.isNullOrEmpty((String)identifier)) {
            logger.warn("Can't normalize null or empty URI: " + identifier);
            return null;
        }
        UriComponentsBuilder builder = UriComponentsBuilder.newInstance();
        Matcher m = pattern.matcher(identifier);
        if (m.matches()) {
            builder.scheme(m.group(2));
            builder.userInfo(m.group(6));
            builder.host(m.group(8));
            String port = m.group(10);
            if (!Strings.isNullOrEmpty((String)port)) {
                builder.port(Integer.parseInt(port));
            }
        } else {
            logger.warn("Parser couldn't match input: " + identifier);
            return null;
        }
        builder.path(m.group(11));
        builder.query(m.group(13));
        builder.fragment(m.group(15));
        UriComponents n = builder.build();
        if (Strings.isNullOrEmpty((String)n.getScheme())) {
            if (!Strings.isNullOrEmpty((String)n.getUserInfo()) && Strings.isNullOrEmpty((String)n.getPath()) && Strings.isNullOrEmpty((String)n.getQuery()) && n.getPort() < 0) {
                builder.scheme("acct");
            } else {
                builder.scheme("https");
            }
        }
        builder.fragment(null);
        return builder.build();
    }

    public static String serializeURL(UriComponents uri) {
        if (uri.getScheme() != null && (uri.getScheme().equals("acct") || uri.getScheme().equals("mailto") || uri.getScheme().equals("tel") || uri.getScheme().equals("device"))) {
            String query;
            String path;
            StringBuilder uriBuilder = new StringBuilder();
            if (uri.getScheme() != null) {
                uriBuilder.append(uri.getScheme());
                uriBuilder.append(':');
            }
            if (uri.getUserInfo() != null || uri.getHost() != null) {
                if (uri.getUserInfo() != null) {
                    uriBuilder.append(uri.getUserInfo());
                    uriBuilder.append('@');
                }
                if (uri.getHost() != null) {
                    uriBuilder.append(uri.getHost());
                }
                if (uri.getPort() != -1) {
                    uriBuilder.append(':');
                    uriBuilder.append(uri.getPort());
                }
            }
            if (StringUtils.hasLength((String)(path = uri.getPath()))) {
                if (uriBuilder.length() != 0 && path.charAt(0) != '/') {
                    uriBuilder.append('/');
                }
                uriBuilder.append(path);
            }
            if ((query = uri.getQuery()) != null) {
                uriBuilder.append('?');
                uriBuilder.append(query);
            }
            if (uri.getFragment() != null) {
                uriBuilder.append('#');
                uriBuilder.append(uri.getFragment());
            }
            return uriBuilder.toString();
        }
        return uri.toUriString();
    }
}

