/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mitre.oauth2.model.PKCEAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger logger = LoggerFactory.getLogger(JsonUtils.class);
    private static Gson gson = new Gson();

    public static JsonElement getAsArray(Set<String> value) {
        return JsonUtils.getAsArray(value, false);
    }

    public static JsonElement getAsArray(Set<String> value, boolean preserveEmpty) {
        if (!preserveEmpty && value != null && value.isEmpty()) {
            return JsonNull.INSTANCE;
        }
        return gson.toJsonTree(value, new TypeToken<Set<String>>(){}.getType());
    }

    public static Date getAsDate(JsonObject o, String member) {
        if (o.has(member)) {
            JsonElement e = o.get(member);
            if (e != null && e.isJsonPrimitive()) {
                return new Date((long)e.getAsInt() * 1000L);
            }
            return null;
        }
        return null;
    }

    public static JWEAlgorithm getAsJweAlgorithm(JsonObject o, String member) {
        String s = JsonUtils.getAsString(o, member);
        if (s != null) {
            return JWEAlgorithm.parse((String)s);
        }
        return null;
    }

    public static EncryptionMethod getAsJweEncryptionMethod(JsonObject o, String member) {
        String s = JsonUtils.getAsString(o, member);
        if (s != null) {
            return EncryptionMethod.parse((String)s);
        }
        return null;
    }

    public static JWSAlgorithm getAsJwsAlgorithm(JsonObject o, String member) {
        String s = JsonUtils.getAsString(o, member);
        if (s != null) {
            return JWSAlgorithm.parse((String)s);
        }
        return null;
    }

    public static PKCEAlgorithm getAsPkceAlgorithm(JsonObject o, String member) {
        String s = JsonUtils.getAsString(o, member);
        if (s != null) {
            return PKCEAlgorithm.parse(s);
        }
        return null;
    }

    public static String getAsString(JsonObject o, String member) {
        if (o.has(member)) {
            JsonElement e = o.get(member);
            if (e != null && e.isJsonPrimitive()) {
                return e.getAsString();
            }
            return null;
        }
        return null;
    }

    public static Boolean getAsBoolean(JsonObject o, String member) {
        if (o.has(member)) {
            JsonElement e = o.get(member);
            if (e != null && e.isJsonPrimitive()) {
                return e.getAsBoolean();
            }
            return null;
        }
        return null;
    }

    public static Long getAsLong(JsonObject o, String member) {
        if (o.has(member)) {
            JsonElement e = o.get(member);
            if (e != null && e.isJsonPrimitive()) {
                return e.getAsLong();
            }
            return null;
        }
        return null;
    }

    public static Set<String> getAsStringSet(JsonObject o, String member) throws JsonSyntaxException {
        if (o.has(member)) {
            if (o.get(member).isJsonArray()) {
                return (Set)gson.fromJson(o.get(member), new TypeToken<Set<String>>(){}.getType());
            }
            return Sets.newHashSet((Object[])new String[]{o.get(member).getAsString()});
        }
        return null;
    }

    public static List<String> getAsStringList(JsonObject o, String member) throws JsonSyntaxException {
        if (o.has(member)) {
            if (o.get(member).isJsonArray()) {
                return (List)gson.fromJson(o.get(member), new TypeToken<List<String>>(){}.getType());
            }
            return Lists.newArrayList((Object[])new String[]{o.get(member).getAsString()});
        }
        return null;
    }

    public static List<JWSAlgorithm> getAsJwsAlgorithmList(JsonObject o, String member) {
        List<String> strings = JsonUtils.getAsStringList(o, member);
        if (strings != null) {
            ArrayList<JWSAlgorithm> algs = new ArrayList<JWSAlgorithm>();
            for (String alg : strings) {
                algs.add(JWSAlgorithm.parse((String)alg));
            }
            return algs;
        }
        return null;
    }

    public static List<JWEAlgorithm> getAsJweAlgorithmList(JsonObject o, String member) {
        List<String> strings = JsonUtils.getAsStringList(o, member);
        if (strings != null) {
            ArrayList<JWEAlgorithm> algs = new ArrayList<JWEAlgorithm>();
            for (String alg : strings) {
                algs.add(JWEAlgorithm.parse((String)alg));
            }
            return algs;
        }
        return null;
    }

    public static List<EncryptionMethod> getAsEncryptionMethodList(JsonObject o, String member) {
        List<String> strings = JsonUtils.getAsStringList(o, member);
        if (strings != null) {
            ArrayList<EncryptionMethod> algs = new ArrayList<EncryptionMethod>();
            for (String alg : strings) {
                algs.add(EncryptionMethod.parse((String)alg));
            }
            return algs;
        }
        return null;
    }

    public static Map readMap(JsonReader reader) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        reader.beginObject();
        block5: while (reader.hasNext()) {
            String name = reader.nextName();
            Object value = null;
            switch (reader.peek()) {
                case STRING: {
                    value = reader.nextString();
                    break;
                }
                case BOOLEAN: {
                    value = reader.nextBoolean();
                    break;
                }
                case NUMBER: {
                    value = reader.nextLong();
                    break;
                }
                default: {
                    logger.debug("Found unexpected entry");
                    reader.skipValue();
                    continue block5;
                }
            }
            map.put(name, value);
        }
        reader.endObject();
        return map;
    }

    public static Set readSet(JsonReader reader) throws IOException {
        HashSet<Object> arraySet = null;
        reader.beginArray();
        switch (reader.peek()) {
            case STRING: {
                arraySet = new HashSet<Object>();
                while (reader.hasNext()) {
                    arraySet.add(reader.nextString());
                }
                break;
            }
            case NUMBER: {
                arraySet = new HashSet();
                while (reader.hasNext()) {
                    arraySet.add(reader.nextLong());
                }
                break;
            }
            default: {
                arraySet = new HashSet();
            }
        }
        reader.endArray();
        return arraySet;
    }

    public static void writeNullSafeArray(JsonWriter writer, Set<String> items) throws IOException {
        if (items != null) {
            writer.beginArray();
            for (String s : items) {
                writer.value(s);
            }
            writer.endArray();
        } else {
            writer.nullValue();
        }
    }
}

