/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.client.service.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWTClaimsSet;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.mitre.jwt.encryption.service.JWTEncryptionAndDecryptionService;
import org.mitre.jwt.signer.service.impl.JWKSetCacheService;
import org.mitre.oauth2.model.RegisteredClient;
import org.mitre.openid.connect.client.service.AuthRequestUrlBuilder;
import org.mitre.openid.connect.config.ServerConfiguration;
import org.springframework.security.authentication.AuthenticationServiceException;

public class EncryptedAuthRequestUrlBuilder
implements AuthRequestUrlBuilder {
    private JWKSetCacheService encrypterService;
    private JWEAlgorithm alg;
    private EncryptionMethod enc;

    @Override
    public String buildAuthRequestUrl(ServerConfiguration serverConfig, RegisteredClient clientConfig, String redirectUri, String nonce, String state, Map<String, String> options, String loginHint) {
        JWTClaimsSet.Builder claims = new JWTClaimsSet.Builder();
        claims.claim("response_type", (Object)"code");
        claims.claim("client_id", (Object)clientConfig.getClientId());
        claims.claim("scope", (Object)Joiner.on((String)" ").join((Iterable)clientConfig.getScope()));
        claims.claim("redirect_uri", (Object)redirectUri);
        claims.claim("nonce", (Object)nonce);
        claims.claim("state", (Object)state);
        for (Map.Entry<String, String> option : options.entrySet()) {
            claims.claim(option.getKey(), (Object)option.getValue());
        }
        if (!Strings.isNullOrEmpty((String)loginHint)) {
            claims.claim("login_hint", (Object)loginHint);
        }
        EncryptedJWT jwt = new EncryptedJWT(new JWEHeader(this.alg, this.enc), claims.build());
        JWTEncryptionAndDecryptionService encryptor = this.encrypterService.getEncrypter(serverConfig.getJwksUri());
        encryptor.encryptJwt((JWEObject)jwt);
        try {
            URIBuilder uriBuilder = new URIBuilder(serverConfig.getAuthorizationEndpointUri());
            uriBuilder.addParameter("request", jwt.serialize());
            return uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new AuthenticationServiceException("Malformed Authorization Endpoint Uri", (Throwable)e);
        }
    }

    public JWKSetCacheService getEncrypterService() {
        return this.encrypterService;
    }

    public void setEncrypterService(JWKSetCacheService encrypterService) {
        this.encrypterService = encrypterService;
    }

    public JWEAlgorithm getAlg() {
        return this.alg;
    }

    public void setAlg(JWEAlgorithm alg) {
        this.alg = alg;
    }

    public EncryptionMethod getEnc() {
        return this.enc;
    }

    public void setEnc(EncryptionMethod enc) {
        this.enc = enc;
    }
}

