/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.uma.web;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.mitre.oauth2.service.SystemScopeService;
import org.mitre.oauth2.web.AuthenticationUtilities;
import org.mitre.openid.connect.config.ConfigurationPropertiesBean;
import org.mitre.uma.model.ResourceSet;
import org.mitre.uma.service.ResourceSetService;
import org.mitre.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/resource_set/resource_set"})
@PreAuthorize(value="hasRole('ROLE_USER')")
public class ResourceSetRegistrationEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(ResourceSetRegistrationEndpoint.class);
    public static final String DISCOVERY_URL = "resource_set";
    public static final String URL = "resource_set/resource_set";
    @Autowired
    private ResourceSetService resourceSetService;
    @Autowired
    private ConfigurationPropertiesBean config;
    @Autowired
    private SystemScopeService scopeService;
    private JsonParser parser = new JsonParser();

    @RequestMapping(method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/json"})
    public String createResourceSet(@RequestBody String jsonString, Model m, Authentication auth) {
        AuthenticationUtilities.ensureOAuthScope((Authentication)auth, (String)"uma_protection");
        ResourceSet rs = this.parseResourceSet(jsonString);
        if (rs == null) {
            logger.warn("Resource set registration missing body.");
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            m.addAttribute("error_description", (Object)"Resource request was missing body.");
            return "jsonErrorView";
        }
        if (!(auth instanceof OAuth2Authentication)) {
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            m.addAttribute("errorMessage", (Object)"This call must be made with an OAuth token");
            return "jsonErrorView";
        }
        OAuth2Authentication o2a = (OAuth2Authentication)auth;
        rs.setClientId(o2a.getOAuth2Request().getClientId());
        rs.setOwner(auth.getName());
        rs = this.validateScopes(rs);
        if (Strings.isNullOrEmpty((String)rs.getName()) || rs.getScopes() == null) {
            logger.warn("Resource set registration missing one or more required fields.");
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            m.addAttribute("errorMessage", (Object)"Resource request was missing one or more required fields.");
            return "jsonErrorView";
        }
        ResourceSet saved = this.resourceSetService.saveNew(rs);
        m.addAttribute("code", (Object)HttpStatus.CREATED);
        m.addAttribute("entity", (Object)saved);
        m.addAttribute("location", (Object)(this.config.getIssuer() + URL + "/" + saved.getId()));
        return "resourceSetEntityAbbreviatedView";
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public String readResourceSet(@PathVariable(value="id") Long id, Model m, Authentication auth) {
        AuthenticationUtilities.ensureOAuthScope((Authentication)auth, (String)"uma_protection");
        ResourceSet rs = this.resourceSetService.getById(id);
        if (rs == null) {
            m.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
            m.addAttribute("error", (Object)"not_found");
            return "jsonErrorView";
        }
        rs = this.validateScopes(rs);
        if (!auth.getName().equals(rs.getOwner())) {
            logger.warn("Unauthorized resource set request from wrong user; expected " + rs.getOwner() + " got " + auth.getName());
            m.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
            return "jsonErrorView";
        }
        m.addAttribute("entity", (Object)rs);
        return "resourceSetEntityView";
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT}, consumes={"application/json"}, produces={"application/json"})
    public String updateResourceSet(@PathVariable(value="id") Long id, @RequestBody String jsonString, Model m, Authentication auth) {
        AuthenticationUtilities.ensureOAuthScope((Authentication)auth, (String)"uma_protection");
        ResourceSet newRs = this.parseResourceSet(jsonString);
        if (newRs == null || Strings.isNullOrEmpty((String)newRs.getName()) || newRs.getScopes() == null || newRs.getId() == null || !newRs.getId().equals(id)) {
            logger.warn("Resource set registration missing one or more required fields.");
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            m.addAttribute("errorMessage", (Object)"Resource request was missing one or more required fields.");
            return "jsonErrorView";
        }
        ResourceSet rs = this.resourceSetService.getById(id);
        if (rs == null) {
            m.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
            m.addAttribute("error", (Object)"not_found");
            return "jsonErrorView";
        }
        if (!auth.getName().equals(rs.getOwner())) {
            logger.warn("Unauthorized resource set request from bad user; expected " + rs.getOwner() + " got " + auth.getName());
            m.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
            return "jsonErrorView";
        }
        ResourceSet saved = this.resourceSetService.update(rs, newRs);
        m.addAttribute("entity", (Object)saved);
        m.addAttribute("location", (Object)(this.config.getIssuer() + URL + "/" + rs.getId()));
        return "resourceSetEntityAbbreviatedView";
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    public String deleteResourceSet(@PathVariable(value="id") Long id, Model m, Authentication auth) {
        AuthenticationUtilities.ensureOAuthScope((Authentication)auth, (String)"uma_protection");
        ResourceSet rs = this.resourceSetService.getById(id);
        if (rs == null) {
            m.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
            m.addAttribute("error", (Object)"not_found");
            return "jsonErrorView";
        }
        if (!auth.getName().equals(rs.getOwner())) {
            logger.warn("Unauthorized resource set request from bad user; expected " + rs.getOwner() + " got " + auth.getName());
            m.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
            return "jsonErrorView";
        }
        if (auth instanceof OAuth2Authentication && !((OAuth2Authentication)auth).getOAuth2Request().getClientId().equals(rs.getClientId())) {
            logger.warn("Unauthorized resource set request from bad client; expected " + rs.getClientId() + " got " + ((OAuth2Authentication)auth).getOAuth2Request().getClientId());
            m.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
            return "jsonErrorView";
        }
        this.resourceSetService.remove(rs);
        m.addAttribute("code", (Object)HttpStatus.NO_CONTENT);
        return "httpCodeView";
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    public String listResourceSets(Model m, Authentication auth) {
        AuthenticationUtilities.ensureOAuthScope((Authentication)auth, (String)"uma_protection");
        String owner = auth.getName();
        Collection<Object> resourceSets = Collections.emptySet();
        if (auth instanceof OAuth2Authentication) {
            OAuth2Authentication o2a = (OAuth2Authentication)auth;
            resourceSets = this.resourceSetService.getAllForOwnerAndClient(owner, o2a.getOAuth2Request().getClientId());
        } else {
            resourceSets = this.resourceSetService.getAllForOwner(owner);
        }
        HashSet<String> ids = new HashSet<String>();
        for (ResourceSet resourceSet : resourceSets) {
            ids.add(resourceSet.getId().toString());
        }
        m.addAttribute("entity", ids);
        return "jsonEntityView";
    }

    private ResourceSet parseResourceSet(String jsonString) {
        try {
            JsonElement el = this.parser.parse(jsonString);
            if (el.isJsonObject()) {
                JsonObject o = el.getAsJsonObject();
                ResourceSet rs = new ResourceSet();
                rs.setId(JsonUtils.getAsLong((JsonObject)o, (String)"_id"));
                rs.setName(JsonUtils.getAsString((JsonObject)o, (String)"name"));
                rs.setIconUri(JsonUtils.getAsString((JsonObject)o, (String)"icon_uri"));
                rs.setType(JsonUtils.getAsString((JsonObject)o, (String)"type"));
                rs.setScopes(JsonUtils.getAsStringSet((JsonObject)o, (String)"scopes"));
                rs.setUri(JsonUtils.getAsString((JsonObject)o, (String)"uri"));
                return rs;
            }
            return null;
        }
        catch (JsonParseException e) {
            return null;
        }
    }

    private ResourceSet validateScopes(ResourceSet rs) {
        Set requestedScopes = this.scopeService.fromStrings(rs.getScopes());
        Set allowedScopes = this.scopeService.removeRestrictedAndReservedScopes(requestedScopes);
        rs.setScopes(this.scopeService.toStrings(allowedScopes));
        return rs;
    }
}

