/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.model.convert;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.text.ParseException;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter
public class JWTStringConverter
implements AttributeConverter<JWT, String> {
    public static Logger logger = LoggerFactory.getLogger(JWTStringConverter.class);

    public String convertToDatabaseColumn(JWT attribute) {
        if (attribute != null) {
            return attribute.serialize();
        }
        return null;
    }

    public JWT convertToEntityAttribute(String dbData) {
        if (dbData != null) {
            try {
                JWT jwt = JWTParser.parse((String)dbData);
                return jwt;
            }
            catch (ParseException e) {
                logger.error("Unable to parse JWT", (Throwable)e);
                return null;
            }
        }
        return null;
    }
}

