/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.mitre.openid.connect.model.Address;
import org.mitre.openid.connect.model.DefaultAddress;
import org.mitre.openid.connect.model.UserInfo;
import org.mitre.openid.connect.model.convert.JsonObjectStringConverter;

@Entity
@Table(name="user_info")
@NamedQueries(value={@NamedQuery(name="DefaultUserInfo.getByUsername", query="select u from DefaultUserInfo u WHERE u.preferredUsername = :username"), @NamedQuery(name="DefaultUserInfo.getByEmailAddress", query="select u from DefaultUserInfo u WHERE u.email = :email")})
public class DefaultUserInfo
implements UserInfo {
    public static final String QUERY_BY_USERNAME = "DefaultUserInfo.getByUsername";
    public static final String QUERY_BY_EMAIL = "DefaultUserInfo.getByEmailAddress";
    public static final String PARAM_USERNAME = "username";
    public static final String PARAM_EMAIL = "email";
    private static final long serialVersionUID = 6078310513185681918L;
    private Long id;
    private String sub;
    private String preferredUsername;
    private String name;
    private String givenName;
    private String familyName;
    private String middleName;
    private String nickname;
    private String profile;
    private String picture;
    private String website;
    private String email;
    private Boolean emailVerified;
    private String gender;
    private String zoneinfo;
    private String locale;
    private String phoneNumber;
    private Boolean phoneNumberVerified;
    private DefaultAddress address;
    private String updatedTime;
    private String birthdate;
    private transient JsonObject src;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Basic
    @Column(name="sub")
    public String getSub() {
        return this.sub;
    }

    @Override
    public void setSub(String sub) {
        this.sub = sub;
    }

    @Override
    @Basic
    @Column(name="preferred_username")
    public String getPreferredUsername() {
        return this.preferredUsername;
    }

    @Override
    public void setPreferredUsername(String preferredUsername) {
        this.preferredUsername = preferredUsername;
    }

    @Override
    @Basic
    @Column(name="name")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Basic
    @Column(name="given_name")
    public String getGivenName() {
        return this.givenName;
    }

    @Override
    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    @Override
    @Basic
    @Column(name="family_name")
    public String getFamilyName() {
        return this.familyName;
    }

    @Override
    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    @Override
    @Basic
    @Column(name="middle_name")
    public String getMiddleName() {
        return this.middleName;
    }

    @Override
    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    @Override
    @Basic
    @Column(name="nickname")
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    @Override
    @Basic
    @Column(name="profile")
    public String getProfile() {
        return this.profile;
    }

    @Override
    public void setProfile(String profile) {
        this.profile = profile;
    }

    @Override
    @Basic
    @Column(name="picture")
    public String getPicture() {
        return this.picture;
    }

    @Override
    public void setPicture(String picture) {
        this.picture = picture;
    }

    @Override
    @Basic
    @Column(name="website")
    public String getWebsite() {
        return this.website;
    }

    @Override
    public void setWebsite(String website) {
        this.website = website;
    }

    @Override
    @Basic
    @Column(name="email")
    public String getEmail() {
        return this.email;
    }

    @Override
    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    @Basic
    @Column(name="email_verified")
    public Boolean getEmailVerified() {
        return this.emailVerified;
    }

    @Override
    public void setEmailVerified(Boolean emailVerified) {
        this.emailVerified = emailVerified;
    }

    @Override
    @Basic
    @Column(name="gender")
    public String getGender() {
        return this.gender;
    }

    @Override
    public void setGender(String gender) {
        this.gender = gender;
    }

    @Override
    @Basic
    @Column(name="zone_info")
    public String getZoneinfo() {
        return this.zoneinfo;
    }

    @Override
    public void setZoneinfo(String zoneinfo) {
        this.zoneinfo = zoneinfo;
    }

    @Override
    @Basic
    @Column(name="locale")
    public String getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Override
    @Basic
    @Column(name="phone_number")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    @Override
    @Basic
    @Column(name="phone_number_verified")
    public Boolean getPhoneNumberVerified() {
        return this.phoneNumberVerified;
    }

    @Override
    public void setPhoneNumberVerified(Boolean phoneNumberVerified) {
        this.phoneNumberVerified = phoneNumberVerified;
    }

    @Override
    @OneToOne(targetEntity=DefaultAddress.class, cascade={CascadeType.ALL})
    @JoinColumn(name="address_id")
    public Address getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(Address address) {
        this.address = address != null ? new DefaultAddress(address) : null;
    }

    @Override
    @Basic
    @Column(name="updated_time")
    public String getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public void setUpdatedTime(String updatedTime) {
        this.updatedTime = updatedTime;
    }

    @Override
    @Basic
    @Column(name="birthdate")
    public String getBirthdate() {
        return this.birthdate;
    }

    @Override
    public void setBirthdate(String birthdate) {
        this.birthdate = birthdate;
    }

    @Override
    public JsonObject toJson() {
        if (this.src == null) {
            JsonObject obj = new JsonObject();
            obj.addProperty("sub", this.getSub());
            obj.addProperty("name", this.getName());
            obj.addProperty("preferred_username", this.getPreferredUsername());
            obj.addProperty("given_name", this.getGivenName());
            obj.addProperty("family_name", this.getFamilyName());
            obj.addProperty("middle_name", this.getMiddleName());
            obj.addProperty("nickname", this.getNickname());
            obj.addProperty("profile", this.getProfile());
            obj.addProperty("picture", this.getPicture());
            obj.addProperty("website", this.getWebsite());
            obj.addProperty("gender", this.getGender());
            obj.addProperty("zoneinfo", this.getZoneinfo());
            obj.addProperty("locale", this.getLocale());
            obj.addProperty("updated_at", this.getUpdatedTime());
            obj.addProperty("birthdate", this.getBirthdate());
            obj.addProperty(PARAM_EMAIL, this.getEmail());
            obj.addProperty("email_verified", this.getEmailVerified());
            obj.addProperty("phone_number", this.getPhoneNumber());
            obj.addProperty("phone_number_verified", this.getPhoneNumberVerified());
            if (this.getAddress() != null) {
                JsonObject addr = new JsonObject();
                addr.addProperty("formatted", this.getAddress().getFormatted());
                addr.addProperty("street_address", this.getAddress().getStreetAddress());
                addr.addProperty("locality", this.getAddress().getLocality());
                addr.addProperty("region", this.getAddress().getRegion());
                addr.addProperty("postal_code", this.getAddress().getPostalCode());
                addr.addProperty("country", this.getAddress().getCountry());
                obj.add("address", (JsonElement)addr);
            }
            return obj;
        }
        return this.src;
    }

    public static UserInfo fromJson(JsonObject obj) {
        DefaultUserInfo ui = new DefaultUserInfo();
        ui.setSource(obj);
        ui.setSub(DefaultUserInfo.nullSafeGetString(obj, "sub"));
        ui.setName(DefaultUserInfo.nullSafeGetString(obj, "name"));
        ui.setPreferredUsername(DefaultUserInfo.nullSafeGetString(obj, "preferred_username"));
        ui.setGivenName(DefaultUserInfo.nullSafeGetString(obj, "given_name"));
        ui.setFamilyName(DefaultUserInfo.nullSafeGetString(obj, "family_name"));
        ui.setMiddleName(DefaultUserInfo.nullSafeGetString(obj, "middle_name"));
        ui.setNickname(DefaultUserInfo.nullSafeGetString(obj, "nickname"));
        ui.setProfile(DefaultUserInfo.nullSafeGetString(obj, "profile"));
        ui.setPicture(DefaultUserInfo.nullSafeGetString(obj, "picture"));
        ui.setWebsite(DefaultUserInfo.nullSafeGetString(obj, "website"));
        ui.setGender(DefaultUserInfo.nullSafeGetString(obj, "gender"));
        ui.setZoneinfo(DefaultUserInfo.nullSafeGetString(obj, "zoneinfo"));
        ui.setLocale(DefaultUserInfo.nullSafeGetString(obj, "locale"));
        ui.setUpdatedTime(DefaultUserInfo.nullSafeGetString(obj, "updated_at"));
        ui.setBirthdate(DefaultUserInfo.nullSafeGetString(obj, "birthdate"));
        ui.setEmail(DefaultUserInfo.nullSafeGetString(obj, PARAM_EMAIL));
        ui.setEmailVerified(obj.has("email_verified") && obj.get("email_verified").isJsonPrimitive() ? Boolean.valueOf(obj.get("email_verified").getAsBoolean()) : null);
        ui.setPhoneNumber(DefaultUserInfo.nullSafeGetString(obj, "phone_number"));
        ui.setPhoneNumberVerified(obj.has("phone_number_verified") && obj.get("phone_number_verified").isJsonPrimitive() ? Boolean.valueOf(obj.get("phone_number_verified").getAsBoolean()) : null);
        if (obj.has("address") && obj.get("address").isJsonObject()) {
            JsonObject addr = obj.get("address").getAsJsonObject();
            ui.setAddress(new DefaultAddress());
            ui.getAddress().setFormatted(DefaultUserInfo.nullSafeGetString(addr, "formatted"));
            ui.getAddress().setStreetAddress(DefaultUserInfo.nullSafeGetString(addr, "street_address"));
            ui.getAddress().setLocality(DefaultUserInfo.nullSafeGetString(addr, "locality"));
            ui.getAddress().setRegion(DefaultUserInfo.nullSafeGetString(addr, "region"));
            ui.getAddress().setPostalCode(DefaultUserInfo.nullSafeGetString(addr, "postal_code"));
            ui.getAddress().setCountry(DefaultUserInfo.nullSafeGetString(addr, "country"));
        }
        return ui;
    }

    @Override
    @Basic
    @Column(name="src")
    @Convert(converter=JsonObjectStringConverter.class)
    public JsonObject getSource() {
        return this.src;
    }

    public void setSource(JsonObject src) {
        this.src = src;
    }

    private static String nullSafeGetString(JsonObject obj, String field) {
        return obj.has(field) && obj.get(field).isJsonPrimitive() ? obj.get(field).getAsString() : null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.birthdate == null ? 0 : this.birthdate.hashCode());
        result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
        result = 31 * result + (this.emailVerified == null ? 0 : this.emailVerified.hashCode());
        result = 31 * result + (this.familyName == null ? 0 : this.familyName.hashCode());
        result = 31 * result + (this.gender == null ? 0 : this.gender.hashCode());
        result = 31 * result + (this.givenName == null ? 0 : this.givenName.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
        result = 31 * result + (this.middleName == null ? 0 : this.middleName.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nickname == null ? 0 : this.nickname.hashCode());
        result = 31 * result + (this.phoneNumber == null ? 0 : this.phoneNumber.hashCode());
        result = 31 * result + (this.phoneNumberVerified == null ? 0 : this.phoneNumberVerified.hashCode());
        result = 31 * result + (this.picture == null ? 0 : this.picture.hashCode());
        result = 31 * result + (this.preferredUsername == null ? 0 : this.preferredUsername.hashCode());
        result = 31 * result + (this.profile == null ? 0 : this.profile.hashCode());
        result = 31 * result + (this.sub == null ? 0 : this.sub.hashCode());
        result = 31 * result + (this.updatedTime == null ? 0 : this.updatedTime.hashCode());
        result = 31 * result + (this.website == null ? 0 : this.website.hashCode());
        result = 31 * result + (this.zoneinfo == null ? 0 : this.zoneinfo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultUserInfo)) {
            return false;
        }
        DefaultUserInfo other = (DefaultUserInfo)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.birthdate == null ? other.birthdate != null : !this.birthdate.equals(other.birthdate)) {
            return false;
        }
        if (this.email == null ? other.email != null : !this.email.equals(other.email)) {
            return false;
        }
        if (this.emailVerified == null ? other.emailVerified != null : !this.emailVerified.equals(other.emailVerified)) {
            return false;
        }
        if (this.familyName == null ? other.familyName != null : !this.familyName.equals(other.familyName)) {
            return false;
        }
        if (this.gender == null ? other.gender != null : !this.gender.equals(other.gender)) {
            return false;
        }
        if (this.givenName == null ? other.givenName != null : !this.givenName.equals(other.givenName)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
            return false;
        }
        if (this.middleName == null ? other.middleName != null : !this.middleName.equals(other.middleName)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.nickname == null ? other.nickname != null : !this.nickname.equals(other.nickname)) {
            return false;
        }
        if (this.phoneNumber == null ? other.phoneNumber != null : !this.phoneNumber.equals(other.phoneNumber)) {
            return false;
        }
        if (this.phoneNumberVerified == null ? other.phoneNumberVerified != null : !this.phoneNumberVerified.equals(other.phoneNumberVerified)) {
            return false;
        }
        if (this.picture == null ? other.picture != null : !this.picture.equals(other.picture)) {
            return false;
        }
        if (this.preferredUsername == null ? other.preferredUsername != null : !this.preferredUsername.equals(other.preferredUsername)) {
            return false;
        }
        if (this.profile == null ? other.profile != null : !this.profile.equals(other.profile)) {
            return false;
        }
        if (this.sub == null ? other.sub != null : !this.sub.equals(other.sub)) {
            return false;
        }
        if (this.updatedTime == null ? other.updatedTime != null : !this.updatedTime.equals(other.updatedTime)) {
            return false;
        }
        if (this.website == null ? other.website != null : !this.website.equals(other.website)) {
            return false;
        }
        return !(this.zoneinfo == null ? other.zoneinfo != null : !this.zoneinfo.equals(other.zoneinfo));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.src == null) {
            out.writeObject(null);
        } else {
            out.writeObject(this.src.toString());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Object o = in.readObject();
        if (o != null) {
            JsonParser parser = new JsonParser();
            this.src = parser.parse((String)o).getAsJsonObject();
        }
    }
}

