/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.model.convert;

import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

@Converter
public class JsonObjectStringConverter
implements AttributeConverter<JsonObject, String> {
    private JsonParser parser = new JsonParser();

    public String convertToDatabaseColumn(JsonObject attribute) {
        if (attribute != null) {
            return attribute.toString();
        }
        return null;
    }

    public JsonObject convertToEntityAttribute(String dbData) {
        if (!Strings.isNullOrEmpty((String)dbData)) {
            return this.parser.parse(dbData).getAsJsonObject();
        }
        return null;
    }
}

