/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.repository.impl;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.mitre.oauth2.model.DeviceCode;
import org.mitre.oauth2.repository.impl.DeviceCodeRepository;
import org.mitre.util.jpa.JpaUtil;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="jpaDeviceCodeRepository")
public class JpaDeviceCodeRepository
implements DeviceCodeRepository {
    @PersistenceContext(unitName="defaultPersistenceUnit")
    private EntityManager em;

    @Transactional(value="defaultTransactionManager")
    public DeviceCode getById(Long id) {
        return (DeviceCode)this.em.find(DeviceCode.class, (Object)id);
    }

    @Transactional(value="defaultTransactionManager")
    public DeviceCode getByUserCode(String value) {
        TypedQuery query = this.em.createNamedQuery("DeviceCode.queryByUserCode", DeviceCode.class);
        query.setParameter("userCode", (Object)value);
        return (DeviceCode)JpaUtil.getSingleResult((List)query.getResultList());
    }

    @Transactional(value="defaultTransactionManager")
    public DeviceCode getByDeviceCode(String value) {
        TypedQuery query = this.em.createNamedQuery("DeviceCode.queryByDeviceCode", DeviceCode.class);
        query.setParameter("deviceCode", (Object)value);
        return (DeviceCode)JpaUtil.getSingleResult((List)query.getResultList());
    }

    @Transactional(value="defaultTransactionManager")
    public void remove(DeviceCode scope) {
        DeviceCode found = this.getById(scope.getId());
        if (found != null) {
            this.em.remove((Object)found);
        }
    }

    @Transactional(value="defaultTransactionManager")
    public DeviceCode save(DeviceCode scope) {
        return (DeviceCode)JpaUtil.saveOrUpdate((Object)scope.getId(), (EntityManager)this.em, (Object)scope);
    }

    @Transactional(value="defaultTransactionManager")
    public Collection<DeviceCode> getExpiredCodes() {
        TypedQuery query = this.em.createNamedQuery("DeviceCode.queryExpiredByDate", DeviceCode.class);
        query.setParameter("date", (Object)new Date());
        return query.getResultList();
    }
}

