/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.model.query;

import java.io.IOException;
import org.eclipse.persistence.jpa.jpql.parser.AggregateFunction;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractSingleEncapsulatedExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;

public abstract class AggregateFunctionStateObject
extends AbstractSingleEncapsulatedExpressionStateObject {
    private boolean distinct;
    public static final String DISTINCT_PROPERTY = "distinct";

    protected AggregateFunctionStateObject(StateObject parent) {
        super(parent);
    }

    protected AggregateFunctionStateObject(StateObject parent, boolean distinct, StateObject stateObject) {
        super(parent, stateObject);
        this.distinct = distinct;
    }

    protected AggregateFunctionStateObject(StateObject parent, boolean distinct, String path) {
        super(parent, path);
        this.distinct = distinct;
    }

    protected AggregateFunctionStateObject(StateObject parent, StateObject stateObject) {
        this(parent, false, stateObject);
    }

    protected AggregateFunctionStateObject(StateObject parent, String path) {
        super(parent, path);
    }

    @Override
    public AggregateFunction getExpression() {
        return (AggregateFunction)super.getExpression();
    }

    public boolean hasDistinct() {
        return this.distinct;
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        if (super.isEquivalent(stateObject)) {
            AggregateFunctionStateObject function = (AggregateFunctionStateObject)stateObject;
            return this.distinct == function.distinct;
        }
        return false;
    }

    public void setDistinct(boolean distinct) {
        boolean oldDistinct = this.distinct;
        this.distinct = distinct;
        this.firePropertyChanged(DISTINCT_PROPERTY, oldDistinct, distinct);
    }

    @Override
    public void setStateObject(StateObject stateObject) {
        super.setStateObject(stateObject);
    }

    public void toggleDistinct() {
        this.setDistinct(!this.hasDistinct());
    }

    @Override
    protected void toTextEncapsulatedExpression(Appendable writer) throws IOException {
        if (this.hasDistinct()) {
            writer.append("DISTINCT");
            writer.append(' ');
        }
        super.toTextEncapsulatedExpression(writer);
    }
}

