/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.uma.service.impl;

import java.util.Date;
import java.util.Set;
import java.util.UUID;
import org.mitre.oauth2.service.SystemScopeService;
import org.mitre.uma.model.Permission;
import org.mitre.uma.model.PermissionTicket;
import org.mitre.uma.model.ResourceSet;
import org.mitre.uma.repository.PermissionRepository;
import org.mitre.uma.service.PermissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.common.exceptions.InsufficientScopeException;
import org.springframework.stereotype.Service;

@Service
public class DefaultPermissionService
implements PermissionService {
    @Autowired
    private PermissionRepository repository;
    @Autowired
    private SystemScopeService scopeService;
    private Long permissionExpirationSeconds = 3600L;

    public PermissionTicket createTicket(ResourceSet resourceSet, Set<String> scopes) {
        if (!this.scopeService.scopesMatch(resourceSet.getScopes(), scopes)) {
            throw new InsufficientScopeException("Scopes of resource set are not enough for requested permission.");
        }
        Permission perm = new Permission();
        perm.setResourceSet(resourceSet);
        perm.setScopes(scopes);
        PermissionTicket ticket = new PermissionTicket();
        ticket.setPermission(perm);
        ticket.setTicket(UUID.randomUUID().toString());
        ticket.setExpiration((Date)new java.sql.Date(System.currentTimeMillis() + this.permissionExpirationSeconds * 1000L));
        return this.repository.save(ticket);
    }

    public PermissionTicket getByTicket(String ticket) {
        return this.repository.getByTicket(ticket);
    }

    public PermissionTicket updateTicket(PermissionTicket ticket) {
        if (ticket.getId() != null) {
            return this.repository.save(ticket);
        }
        return null;
    }
}

