/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token.store.jwk;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.security.jwt.codec.Codecs;
import org.springframework.security.jwt.crypto.sign.RsaVerifier;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkDefinition;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkException;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkSetConverter;
import org.springframework.security.oauth2.provider.token.store.jwk.RsaJwkDefinition;

class JwkDefinitionSource {
    private final URL jwkSetUrl;
    private final Map<String, JwkDefinitionHolder> jwkDefinitions = new ConcurrentHashMap<String, JwkDefinitionHolder>();
    private static final JwkSetConverter jwkSetConverter = new JwkSetConverter();

    JwkDefinitionSource(String jwkSetUrl) {
        try {
            this.jwkSetUrl = new URL(jwkSetUrl);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Invalid JWK Set URL: " + ex.getMessage(), ex);
        }
    }

    JwkDefinition getDefinition(String keyId) {
        JwkDefinition result = null;
        JwkDefinitionHolder jwkDefinitionHolder = this.jwkDefinitions.get(keyId);
        if (jwkDefinitionHolder != null) {
            result = jwkDefinitionHolder.getJwkDefinition();
        }
        return result;
    }

    JwkDefinition getDefinitionLoadIfNecessary(String keyId) {
        JwkDefinition result = this.getDefinition(keyId);
        if (result != null) {
            return result;
        }
        this.jwkDefinitions.clear();
        this.jwkDefinitions.putAll(JwkDefinitionSource.loadJwkDefinitions(this.jwkSetUrl));
        return this.getDefinition(keyId);
    }

    SignatureVerifier getVerifier(String keyId) {
        SignatureVerifier result = null;
        JwkDefinition jwkDefinition = this.getDefinitionLoadIfNecessary(keyId);
        if (jwkDefinition != null) {
            result = this.jwkDefinitions.get(keyId).getSignatureVerifier();
        }
        return result;
    }

    static Map<String, JwkDefinitionHolder> loadJwkDefinitions(URL jwkSetUrl) {
        InputStream jwkSetSource;
        try {
            jwkSetSource = jwkSetUrl.openStream();
        }
        catch (IOException ex) {
            throw new JwkException("An I/O error occurred while reading from the JWK Set source: " + ex.getMessage(), ex);
        }
        Set<JwkDefinition> jwkDefinitionSet = jwkSetConverter.convert(jwkSetSource);
        LinkedHashMap<String, JwkDefinitionHolder> jwkDefinitions = new LinkedHashMap<String, JwkDefinitionHolder>();
        for (JwkDefinition jwkDefinition : jwkDefinitionSet) {
            if (!JwkDefinition.KeyType.RSA.equals((Object)jwkDefinition.getKeyType())) continue;
            jwkDefinitions.put(jwkDefinition.getKeyId(), new JwkDefinitionHolder(jwkDefinition, (SignatureVerifier)JwkDefinitionSource.createRsaVerifier((RsaJwkDefinition)jwkDefinition)));
        }
        return jwkDefinitions;
    }

    private static RsaVerifier createRsaVerifier(RsaJwkDefinition rsaDefinition) {
        RsaVerifier result;
        try {
            BigInteger modulus = new BigInteger(Codecs.b64UrlDecode((CharSequence)rsaDefinition.getModulus()));
            BigInteger exponent = new BigInteger(Codecs.b64UrlDecode((CharSequence)rsaDefinition.getExponent()));
            RSAPublicKey rsaPublicKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(modulus, exponent));
            result = new RsaVerifier(rsaPublicKey, rsaDefinition.getAlgorithm().standardName());
        }
        catch (Exception ex) {
            throw new JwkException("An error occurred while creating a RSA Public Key Verifier for " + rsaDefinition.getKeyId() + " : " + ex.getMessage(), ex);
        }
        return result;
    }

    static class JwkDefinitionHolder {
        private final JwkDefinition jwkDefinition;
        private final SignatureVerifier signatureVerifier;

        private JwkDefinitionHolder(JwkDefinition jwkDefinition, SignatureVerifier signatureVerifier) {
            this.jwkDefinition = jwkDefinition;
            this.signatureVerifier = signatureVerifier;
        }

        private JwkDefinition getJwkDefinition() {
            return this.jwkDefinition;
        }

        private SignatureVerifier getSignatureVerifier() {
            return this.signatureVerifier;
        }
    }
}

