/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.web;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import java.lang.reflect.Type;
import java.sql.SQLIntegrityConstraintViolationException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.PersistenceException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.mitre.jwt.assertion.AssertionValidator;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.PKCEAlgorithm;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.oauth2.web.AuthenticationUtilities;
import org.mitre.openid.connect.exception.ValidationException;
import org.mitre.openid.connect.model.CachedImage;
import org.mitre.openid.connect.service.ClientLogoLoadingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/api/clients"})
@PreAuthorize(value="hasRole('ROLE_USER')")
public class ClientAPI {
    public static final String URL = "api/clients";
    @Autowired
    private ClientDetailsEntityService clientService;
    @Autowired
    private ClientLogoLoadingService clientLogoLoadingService;
    @Autowired
    @Qualifier(value="clientAssertionValidator")
    private AssertionValidator assertionValidator;
    private JsonParser parser = new JsonParser();
    private Gson gson = new GsonBuilder().serializeNulls().registerTypeAdapter(JWSAlgorithm.class, (Object)new JsonDeserializer<Algorithm>(){

        public JWSAlgorithm deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                return JWSAlgorithm.parse((String)json.getAsString());
            }
            return null;
        }
    }).registerTypeAdapter(JWEAlgorithm.class, (Object)new JsonDeserializer<Algorithm>(){

        public JWEAlgorithm deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                return JWEAlgorithm.parse((String)json.getAsString());
            }
            return null;
        }
    }).registerTypeAdapter(EncryptionMethod.class, (Object)new JsonDeserializer<Algorithm>(){

        public EncryptionMethod deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                return EncryptionMethod.parse((String)json.getAsString());
            }
            return null;
        }
    }).registerTypeAdapter(JWKSet.class, (Object)new JsonDeserializer<JWKSet>(){

        public JWKSet deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                try {
                    return JWKSet.parse((String)json.toString());
                }
                catch (ParseException e) {
                    return null;
                }
            }
            return null;
        }
    }).registerTypeAdapter(JWT.class, (Object)new JsonDeserializer<JWT>(){

        public JWT deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                try {
                    return JWTParser.parse((String)json.getAsString());
                }
                catch (ParseException e) {
                    return null;
                }
            }
            return null;
        }
    }).registerTypeAdapter(PKCEAlgorithm.class, (Object)new JsonDeserializer<Algorithm>(){

        public PKCEAlgorithm deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                return PKCEAlgorithm.parse((String)json.getAsString());
            }
            return null;
        }
    }).setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();
    private static final Logger logger = LoggerFactory.getLogger(ClientAPI.class);

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    public String apiGetAllClients(Model model, Authentication auth) {
        Collection clients = this.clientService.getAllClients();
        model.addAttribute("entity", (Object)clients);
        if (AuthenticationUtilities.isAdmin(auth)) {
            return "clientEntityViewAdmins";
        }
        return "clientEntityViewUsers";
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String apiAddClient(@RequestBody String jsonString, Model m, Authentication auth) {
        JsonObject json = null;
        ClientDetailsEntity client = null;
        try {
            json = this.parser.parse(jsonString).getAsJsonObject();
            client = (ClientDetailsEntity)this.gson.fromJson((JsonElement)json, ClientDetailsEntity.class);
            client = this.validateSoftwareStatement(client);
        }
        catch (JsonSyntaxException e) {
            logger.error("apiAddClient failed due to JsonSyntaxException", (Throwable)e);
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            m.addAttribute("errorMessage", (Object)"Could not save new client. The server encountered a JSON syntax exception. Contact a system administrator for assistance.");
            return "jsonErrorView";
        }
        catch (IllegalStateException e) {
            logger.error("apiAddClient failed due to IllegalStateException", (Throwable)e);
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            m.addAttribute("errorMessage", (Object)"Could not save new client. The server encountered an IllegalStateException. Refresh and try again - if the problem persists, contact a system administrator for assistance.");
            return "jsonErrorView";
        }
        catch (ValidationException e) {
            logger.error("apiUpdateClient failed due to ValidationException", (Throwable)e);
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            m.addAttribute("errorMessage", (Object)"Could not update client. The server encountered a ValidationException.");
            return "jsonErrorView";
        }
        if (Strings.isNullOrEmpty((String)client.getClientId())) {
            client = this.clientService.generateClientId(client);
        }
        if (client.getTokenEndpointAuthMethod() == null || client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.NONE)) {
            client.setClientSecret(null);
        } else if (client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.SECRET_BASIC) || client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.SECRET_POST) || client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.SECRET_JWT)) {
            if (json.has("generateClientSecret") && json.get("generateClientSecret").getAsBoolean() || Strings.isNullOrEmpty((String)client.getClientSecret())) {
                client = this.clientService.generateClientSecret(client);
            }
        } else if (client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.PRIVATE_KEY)) {
            if (Strings.isNullOrEmpty((String)client.getJwksUri()) && client.getJwks() == null) {
                logger.error("tried to create client with private key auth but no private key");
                m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
                m.addAttribute("errorMessage", (Object)"Can not create a client with private key authentication without registering a key via the JWK Set URI or JWK Set Value.");
                return "jsonErrorView";
            }
            client.setClientSecret(null);
        } else {
            logger.error("unknown auth method");
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            m.addAttribute("errorMessage", (Object)"Unknown auth method requested");
            return "jsonErrorView";
        }
        client.setDynamicallyRegistered(false);
        try {
            ClientDetailsEntity newClient = this.clientService.saveNewClient(client);
            m.addAttribute("entity", (Object)newClient);
            if (AuthenticationUtilities.isAdmin(auth)) {
                return "clientEntityViewAdmins";
            }
            return "clientEntityViewUsers";
        }
        catch (IllegalArgumentException e) {
            logger.error("Unable to save client: {}", (Object)e.getMessage());
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            m.addAttribute("errorMessage", (Object)("Unable to save client: " + e.getMessage()));
            return "jsonErrorView";
        }
        catch (PersistenceException e) {
            Throwable databaseExceptionCause;
            Throwable cause = e.getCause();
            if (cause instanceof DatabaseException && (databaseExceptionCause = cause.getCause()) instanceof SQLIntegrityConstraintViolationException) {
                logger.error("apiAddClient failed; duplicate client id entry found: {}", (Object)client.getClientId());
                m.addAttribute("code", (Object)HttpStatus.CONFLICT);
                m.addAttribute("errorMessage", (Object)("Unable to save client. Duplicate client id entry found: " + client.getClientId()));
                return "jsonErrorView";
            }
            throw e;
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT}, consumes={"application/json"}, produces={"application/json"})
    public String apiUpdateClient(@PathVariable(value="id") Long id, @RequestBody String jsonString, Model m, Authentication auth) {
        JsonObject json = null;
        ClientDetailsEntity client = null;
        try {
            json = this.parser.parse(jsonString).getAsJsonObject();
            client = (ClientDetailsEntity)this.gson.fromJson((JsonElement)json, ClientDetailsEntity.class);
            client = this.validateSoftwareStatement(client);
        }
        catch (JsonSyntaxException e) {
            logger.error("apiUpdateClient failed due to JsonSyntaxException", (Throwable)e);
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            m.addAttribute("errorMessage", (Object)"Could not update client. The server encountered a JSON syntax exception. Contact a system administrator for assistance.");
            return "jsonErrorView";
        }
        catch (IllegalStateException e) {
            logger.error("apiUpdateClient failed due to IllegalStateException", (Throwable)e);
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            m.addAttribute("errorMessage", (Object)"Could not update client. The server encountered an IllegalStateException. Refresh and try again - if the problem persists, contact a system administrator for assistance.");
            return "jsonErrorView";
        }
        catch (ValidationException e) {
            logger.error("apiUpdateClient failed due to ValidationException", (Throwable)e);
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            m.addAttribute("errorMessage", (Object)"Could not update client. The server encountered a ValidationException.");
            return "jsonErrorView";
        }
        ClientDetailsEntity oldClient = this.clientService.getClientById(id);
        if (oldClient == null) {
            logger.error("apiUpdateClient failed; client with id " + id + " could not be found.");
            m.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
            m.addAttribute("errorMessage", (Object)("Could not update client. The requested client with id " + id + "could not be found."));
            return "jsonErrorView";
        }
        if (Strings.isNullOrEmpty((String)client.getClientId())) {
            client = this.clientService.generateClientId(client);
        }
        if (client.getTokenEndpointAuthMethod() == null || client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.NONE)) {
            client.setClientSecret(null);
        } else if (client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.SECRET_BASIC) || client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.SECRET_POST) || client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.SECRET_JWT)) {
            if (json.has("generateClientSecret") && json.get("generateClientSecret").getAsBoolean() || Strings.isNullOrEmpty((String)client.getClientSecret())) {
                client = this.clientService.generateClientSecret(client);
            }
        } else if (client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.PRIVATE_KEY)) {
            if (Strings.isNullOrEmpty((String)client.getJwksUri()) && client.getJwks() == null) {
                logger.error("tried to create client with private key auth but no private key");
                m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
                m.addAttribute("errorMessage", (Object)"Can not create a client with private key authentication without registering a key via the JWK Set URI or JWK Set Value.");
                return "jsonErrorView";
            }
            client.setClientSecret(null);
        } else {
            logger.error("unknown auth method");
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            m.addAttribute("errorMessage", (Object)"Unknown auth method requested");
            return "jsonErrorView";
        }
        try {
            ClientDetailsEntity newClient = this.clientService.updateClient(oldClient, client);
            m.addAttribute("entity", (Object)newClient);
            if (AuthenticationUtilities.isAdmin(auth)) {
                return "clientEntityViewAdmins";
            }
            return "clientEntityViewUsers";
        }
        catch (IllegalArgumentException e) {
            logger.error("Unable to save client: {}", (Object)e.getMessage());
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            m.addAttribute("errorMessage", (Object)("Unable to save client: " + e.getMessage()));
            return "jsonErrorView";
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public String apiDeleteClient(@PathVariable(value="id") Long id, ModelAndView modelAndView) {
        ClientDetailsEntity client = this.clientService.getClientById(id);
        if (client == null) {
            logger.error("apiDeleteClient failed; client with id " + id + " could not be found.");
            modelAndView.getModelMap().put((Object)"code", (Object)HttpStatus.NOT_FOUND);
            modelAndView.getModelMap().put((Object)"errorMessage", (Object)("Could not delete client. The requested client with id " + id + "could not be found."));
            return "jsonErrorView";
        }
        modelAndView.getModelMap().put((Object)"code", (Object)HttpStatus.OK);
        this.clientService.deleteClient(client);
        return "httpCodeView";
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public String apiShowClient(@PathVariable(value="id") Long id, Model model, Authentication auth) {
        ClientDetailsEntity client = this.clientService.getClientById(id);
        if (client == null) {
            logger.error("apiShowClient failed; client with id " + id + " could not be found.");
            model.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
            model.addAttribute("errorMessage", (Object)("The requested client with id " + id + " could not be found."));
            return "jsonErrorView";
        }
        model.addAttribute("entity", (Object)client);
        if (AuthenticationUtilities.isAdmin(auth)) {
            return "clientEntityViewAdmins";
        }
        return "clientEntityViewUsers";
    }

    @RequestMapping(value={"/{id}/logo"}, method={RequestMethod.GET}, produces={"image/gif", "image/jpeg", "image/png"})
    public ResponseEntity<byte[]> getClientLogo(@PathVariable(value="id") Long id, Model model) {
        ClientDetailsEntity client = this.clientService.getClientById(id);
        if (client == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        if (Strings.isNullOrEmpty((String)client.getLogoUri())) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        CachedImage image = this.clientLogoLoadingService.getLogo(client);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)image.getContentType()));
        headers.setContentLength(image.getLength());
        return new ResponseEntity((Object)image.getData(), (MultiValueMap)headers, HttpStatus.OK);
    }

    private ClientDetailsEntity validateSoftwareStatement(ClientDetailsEntity newClient) throws ValidationException {
        if (newClient.getSoftwareStatement() != null) {
            if (this.assertionValidator.isValid(newClient.getSoftwareStatement())) {
                try {
                    JWTClaimsSet claimSet = newClient.getSoftwareStatement().getJWTClaimsSet();
                    Iterator iterator = claimSet.getClaims().keySet().iterator();
                    block82: while (iterator.hasNext()) {
                        String claim;
                        switch (claim = (String)iterator.next()) {
                            case "software_statement": {
                                throw new ValidationException("invalid_client_metadata", "Software statement can't include another software statement", HttpStatus.BAD_REQUEST);
                            }
                            case "claims_redirect_uris": {
                                newClient.setClaimsRedirectUris((Set)Sets.newHashSet((Iterable)claimSet.getStringListClaim(claim)));
                                continue block82;
                            }
                            case "client_secret_expires_at": {
                                throw new ValidationException("invalid_client_metadata", "Software statement can't include a client secret expiration time", HttpStatus.BAD_REQUEST);
                            }
                            case "client_id_issued_at": {
                                throw new ValidationException("invalid_client_metadata", "Software statement can't include a client ID issuance time", HttpStatus.BAD_REQUEST);
                            }
                            case "registration_client_uri": {
                                throw new ValidationException("invalid_client_metadata", "Software statement can't include a client configuration endpoint", HttpStatus.BAD_REQUEST);
                            }
                            case "registration_access_token": {
                                throw new ValidationException("invalid_client_metadata", "Software statement can't include a client registration access token", HttpStatus.BAD_REQUEST);
                            }
                            case "request_uris": {
                                newClient.setRequestUris((Set)Sets.newHashSet((Iterable)claimSet.getStringListClaim(claim)));
                                continue block82;
                            }
                            case "post_logout_redirect_uris": {
                                newClient.setPostLogoutRedirectUris((Set)Sets.newHashSet((Iterable)claimSet.getStringListClaim(claim)));
                                continue block82;
                            }
                            case "initiate_login_uri": {
                                newClient.setInitiateLoginUri(claimSet.getStringClaim(claim));
                                continue block82;
                            }
                            case "default_acr_values": {
                                newClient.setDefaultACRvalues((Set)Sets.newHashSet((Iterable)claimSet.getStringListClaim(claim)));
                                continue block82;
                            }
                            case "require_auth_time": {
                                newClient.setRequireAuthTime(claimSet.getBooleanClaim(claim));
                                continue block82;
                            }
                            case "default_max_age": {
                                newClient.setDefaultMaxAge(claimSet.getIntegerClaim(claim));
                                continue block82;
                            }
                            case "token_endpoint_auth_signing_alg": {
                                newClient.setTokenEndpointAuthSigningAlg(JWSAlgorithm.parse((String)claimSet.getStringClaim(claim)));
                                continue block82;
                            }
                            case "id_token_encrypted_response_enc": {
                                newClient.setIdTokenEncryptedResponseEnc(EncryptionMethod.parse((String)claimSet.getStringClaim(claim)));
                                continue block82;
                            }
                            case "id_token_encrypted_response_alg": {
                                newClient.setIdTokenEncryptedResponseAlg(JWEAlgorithm.parse((String)claimSet.getStringClaim(claim)));
                                continue block82;
                            }
                            case "id_token_signed_response_alg": {
                                newClient.setIdTokenSignedResponseAlg(JWSAlgorithm.parse((String)claimSet.getStringClaim(claim)));
                                continue block82;
                            }
                            case "userinfo_encrypted_response_enc": {
                                newClient.setUserInfoEncryptedResponseEnc(EncryptionMethod.parse((String)claimSet.getStringClaim(claim)));
                                continue block82;
                            }
                            case "userinfo_encrypted_response_alg": {
                                newClient.setUserInfoEncryptedResponseAlg(JWEAlgorithm.parse((String)claimSet.getStringClaim(claim)));
                                continue block82;
                            }
                            case "userinfo_signed_response_alg": {
                                newClient.setUserInfoSignedResponseAlg(JWSAlgorithm.parse((String)claimSet.getStringClaim(claim)));
                                continue block82;
                            }
                            case "request_object_signing_alg": {
                                newClient.setRequestObjectSigningAlg(JWSAlgorithm.parse((String)claimSet.getStringClaim(claim)));
                                continue block82;
                            }
                            case "subject_type": {
                                newClient.setSubjectType(ClientDetailsEntity.SubjectType.getByValue((String)claimSet.getStringClaim(claim)));
                                continue block82;
                            }
                            case "sector_identifier_uri": {
                                newClient.setSectorIdentifierUri(claimSet.getStringClaim(claim));
                                continue block82;
                            }
                            case "application_type": {
                                newClient.setApplicationType(ClientDetailsEntity.AppType.getByValue((String)claimSet.getStringClaim(claim)));
                                continue block82;
                            }
                            case "jwks_uri": {
                                newClient.setJwksUri(claimSet.getStringClaim(claim));
                                continue block82;
                            }
                            case "jwks": {
                                newClient.setJwks(JWKSet.parse((String)claimSet.getJSONObjectClaim(claim).toJSONString()));
                                continue block82;
                            }
                            case "policy_uri": {
                                newClient.setPolicyUri(claimSet.getStringClaim(claim));
                                continue block82;
                            }
                            case "response_types": {
                                newClient.setResponseTypes((Set)Sets.newHashSet((Iterable)claimSet.getStringListClaim(claim)));
                                continue block82;
                            }
                            case "grant_types": {
                                newClient.setGrantTypes((Set)Sets.newHashSet((Iterable)claimSet.getStringListClaim(claim)));
                                continue block82;
                            }
                            case "scope": {
                                newClient.setScope(OAuth2Utils.parseParameterList((String)claimSet.getStringClaim(claim)));
                                continue block82;
                            }
                            case "token_endpoint_auth_method": {
                                newClient.setTokenEndpointAuthMethod(ClientDetailsEntity.AuthMethod.getByValue((String)claimSet.getStringClaim(claim)));
                                continue block82;
                            }
                            case "tos_uri": {
                                newClient.setTosUri(claimSet.getStringClaim(claim));
                                continue block82;
                            }
                            case "contacts": {
                                newClient.setContacts((Set)Sets.newHashSet((Iterable)claimSet.getStringListClaim(claim)));
                                continue block82;
                            }
                            case "logo_uri": {
                                newClient.setLogoUri(claimSet.getStringClaim(claim));
                                continue block82;
                            }
                            case "client_uri": {
                                newClient.setClientUri(claimSet.getStringClaim(claim));
                                continue block82;
                            }
                            case "client_name": {
                                newClient.setClientName(claimSet.getStringClaim(claim));
                                continue block82;
                            }
                            case "redirect_uris": {
                                newClient.setRedirectUris((Set)Sets.newHashSet((Iterable)claimSet.getStringListClaim(claim)));
                                continue block82;
                            }
                            case "client_secret": {
                                throw new ValidationException("invalid_client_metadata", "Software statement can't contain client secret", HttpStatus.BAD_REQUEST);
                            }
                            case "client_id": {
                                throw new ValidationException("invalid_client_metadata", "Software statement can't contain client ID", HttpStatus.BAD_REQUEST);
                            }
                        }
                        logger.warn("Software statement contained unknown field: " + claim + " with value " + claimSet.getClaim(claim));
                    }
                    return newClient;
                }
                catch (ParseException e) {
                    throw new ValidationException("invalid_client_metadata", "Software statement claims didn't parse", HttpStatus.BAD_REQUEST);
                }
            }
            throw new ValidationException("invalid_client_metadata", "Software statement rejected by validator", HttpStatus.BAD_REQUEST);
        }
        return newClient;
    }
}

