/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.model;

import com.nimbusds.jwt.JWT;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.mitre.oauth2.model.AuthenticationHolderEntity;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.OAuth2RefreshTokenEntity;
import org.mitre.oauth2.model.convert.JWTStringConverter;
import org.mitre.openid.connect.model.ApprovedSite;
import org.mitre.uma.model.Permission;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessTokenJackson1Deserializer;
import org.springframework.security.oauth2.common.OAuth2AccessTokenJackson1Serializer;
import org.springframework.security.oauth2.common.OAuth2AccessTokenJackson2Deserializer;
import org.springframework.security.oauth2.common.OAuth2AccessTokenJackson2Serializer;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;

@Entity
@Table(name="access_token")
@NamedQueries(value={@NamedQuery(name="OAuth2AccessTokenEntity.getAll", query="select a from OAuth2AccessTokenEntity a"), @NamedQuery(name="OAuth2AccessTokenEntity.getAllExpiredByDate", query="select a from OAuth2AccessTokenEntity a where a.expiration <= :date"), @NamedQuery(name="OAuth2AccessTokenEntity.getByRefreshToken", query="select a from OAuth2AccessTokenEntity a where a.refreshToken = :refreshToken"), @NamedQuery(name="OAuth2AccessTokenEntity.getByClient", query="select a from OAuth2AccessTokenEntity a where a.client = :client"), @NamedQuery(name="OAuth2AccessTokenEntity.getByTokenValue", query="select a from OAuth2AccessTokenEntity a where a.jwt = :tokenValue"), @NamedQuery(name="OAuth2AccessTokenEntity.getByApprovedSite", query="select a from OAuth2AccessTokenEntity a where a.approvedSite = :approvedSite"), @NamedQuery(name="OAuth2AccessTokenEntity.getByResourceSet", query="select a from OAuth2AccessTokenEntity a join a.permissions p where p.resourceSet.id = :rsid"), @NamedQuery(name="OAuth2AccessTokenEntity.getByName", query="select r from OAuth2AccessTokenEntity r where r.authenticationHolder.userAuth.name = :name")})
@JsonSerialize(using=OAuth2AccessTokenJackson1Serializer.class)
@JsonDeserialize(using=OAuth2AccessTokenJackson1Deserializer.class)
@com.fasterxml.jackson.databind.annotation.JsonSerialize(using=OAuth2AccessTokenJackson2Serializer.class)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(using=OAuth2AccessTokenJackson2Deserializer.class)
public class OAuth2AccessTokenEntity
implements OAuth2AccessToken {
    public static final String QUERY_BY_APPROVED_SITE = "OAuth2AccessTokenEntity.getByApprovedSite";
    public static final String QUERY_BY_TOKEN_VALUE = "OAuth2AccessTokenEntity.getByTokenValue";
    public static final String QUERY_BY_CLIENT = "OAuth2AccessTokenEntity.getByClient";
    public static final String QUERY_BY_REFRESH_TOKEN = "OAuth2AccessTokenEntity.getByRefreshToken";
    public static final String QUERY_EXPIRED_BY_DATE = "OAuth2AccessTokenEntity.getAllExpiredByDate";
    public static final String QUERY_ALL = "OAuth2AccessTokenEntity.getAll";
    public static final String QUERY_BY_RESOURCE_SET = "OAuth2AccessTokenEntity.getByResourceSet";
    public static final String QUERY_BY_NAME = "OAuth2AccessTokenEntity.getByName";
    public static final String PARAM_TOKEN_VALUE = "tokenValue";
    public static final String PARAM_CLIENT = "client";
    public static final String PARAM_REFERSH_TOKEN = "refreshToken";
    public static final String PARAM_DATE = "date";
    public static final String PARAM_RESOURCE_SET_ID = "rsid";
    public static final String PARAM_APPROVED_SITE = "approvedSite";
    public static final String PARAM_NAME = "name";
    public static final String ID_TOKEN_FIELD_NAME = "id_token";
    private Long id;
    private ClientDetailsEntity client;
    private AuthenticationHolderEntity authenticationHolder;
    private JWT jwtValue;
    private Date expiration;
    private String tokenType = "Bearer";
    private OAuth2RefreshTokenEntity refreshToken;
    private Set<String> scope;
    private Set<Permission> permissions;
    private ApprovedSite approvedSite;
    private Map<String, Object> additionalInformation = new HashMap<String, Object>();

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Transient
    public Map<String, Object> getAdditionalInformation() {
        return this.additionalInformation;
    }

    @ManyToOne
    @JoinColumn(name="auth_holder_id")
    public AuthenticationHolderEntity getAuthenticationHolder() {
        return this.authenticationHolder;
    }

    public void setAuthenticationHolder(AuthenticationHolderEntity authenticationHolder) {
        this.authenticationHolder = authenticationHolder;
    }

    @ManyToOne
    @JoinColumn(name="client_id")
    public ClientDetailsEntity getClient() {
        return this.client;
    }

    public void setClient(ClientDetailsEntity client) {
        this.client = client;
    }

    @Transient
    public String getValue() {
        return this.jwtValue.serialize();
    }

    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="expiration")
    public Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    @Basic
    @Column(name="token_type")
    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    @ManyToOne
    @JoinColumn(name="refresh_token_id")
    public OAuth2RefreshTokenEntity getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(OAuth2RefreshTokenEntity refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setRefreshToken(OAuth2RefreshToken refreshToken) {
        if (!(refreshToken instanceof OAuth2RefreshTokenEntity)) {
            throw new IllegalArgumentException("Not a storable refresh token entity!");
        }
        this.setRefreshToken((OAuth2RefreshTokenEntity)refreshToken);
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(joinColumns={@JoinColumn(name="owner_id")}, name="token_scope")
    public Set<String> getScope() {
        return this.scope;
    }

    public void setScope(Set<String> scope) {
        this.scope = scope;
    }

    @Transient
    public boolean isExpired() {
        return this.getExpiration() == null ? false : System.currentTimeMillis() > this.getExpiration().getTime();
    }

    @Basic
    @Column(name="token_value")
    @Convert(converter=JWTStringConverter.class)
    public JWT getJwt() {
        return this.jwtValue;
    }

    public void setJwt(JWT jwt) {
        this.jwtValue = jwt;
    }

    @Transient
    public int getExpiresIn() {
        if (this.getExpiration() == null) {
            return -1;
        }
        int secondsRemaining = (int)((this.getExpiration().getTime() - System.currentTimeMillis()) / 1000L);
        if (this.isExpired()) {
            return 0;
        }
        return secondsRemaining;
    }

    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinTable(name="access_token_permissions", joinColumns={@JoinColumn(name="access_token_id")}, inverseJoinColumns={@JoinColumn(name="permission_id")})
    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<Permission> permissions) {
        this.permissions = permissions;
    }

    @ManyToOne
    @JoinColumn(name="approved_site_id")
    public ApprovedSite getApprovedSite() {
        return this.approvedSite;
    }

    public void setApprovedSite(ApprovedSite approvedSite) {
        this.approvedSite = approvedSite;
    }

    @Transient
    public void setIdToken(JWT idToken) {
        if (idToken != null) {
            this.additionalInformation.put(ID_TOKEN_FIELD_NAME, idToken.serialize());
        }
    }
}

