/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.uma.repository.impl;

import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.mitre.uma.model.Permission;
import org.mitre.uma.model.PermissionTicket;
import org.mitre.uma.model.ResourceSet;
import org.mitre.uma.repository.PermissionRepository;
import org.mitre.util.jpa.JpaUtil;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JpaPermissionRepository
implements PermissionRepository {
    @PersistenceContext(unitName="defaultPersistenceUnit")
    private EntityManager em;

    @Transactional(value="defaultTransactionManager")
    public PermissionTicket save(PermissionTicket p) {
        return (PermissionTicket)JpaUtil.saveOrUpdate((Object)p.getId(), (EntityManager)this.em, (Object)p);
    }

    public PermissionTicket getByTicket(String ticket) {
        TypedQuery query = this.em.createNamedQuery("PermissionTicket.queryByTicket", PermissionTicket.class);
        query.setParameter("ticket", (Object)ticket);
        return (PermissionTicket)JpaUtil.getSingleResult((List)query.getResultList());
    }

    public Collection<PermissionTicket> getAll() {
        TypedQuery query = this.em.createNamedQuery("PermissionTicket.queryAll", PermissionTicket.class);
        return query.getResultList();
    }

    @Transactional(value="defaultTransactionManager")
    public Permission saveRawPermission(Permission p) {
        return (Permission)JpaUtil.saveOrUpdate((Object)p.getId(), (EntityManager)this.em, (Object)p);
    }

    public Permission getById(Long permissionId) {
        return (Permission)this.em.find(Permission.class, (Object)permissionId);
    }

    public Collection<PermissionTicket> getPermissionTicketsForResourceSet(ResourceSet rs) {
        TypedQuery query = this.em.createNamedQuery("PermissionTicket.queryByResourceSet", PermissionTicket.class);
        query.setParameter("rsid", (Object)rs.getId());
        return query.getResultList();
    }

    @Transactional(value="defaultTransactionManager")
    public void remove(PermissionTicket ticket) {
        PermissionTicket found = this.getByTicket(ticket.getTicket());
        if (found != null) {
            this.em.remove((Object)found);
        }
    }
}

