/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.web;

import java.util.Map;
import org.mitre.openid.connect.model.ClientStat;
import org.mitre.openid.connect.service.StatsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/api/stats"})
public class StatsAPI {
    public static final String URL = "api/stats";
    private static final Logger logger = LoggerFactory.getLogger(StatsAPI.class);
    @Autowired
    private StatsService statsService;

    @RequestMapping(value={"summary"}, produces={"application/json"})
    public String statsSummary(ModelMap m) {
        Map e = this.statsService.getSummaryStats();
        m.put((Object)"entity", (Object)e);
        return "jsonEntityView";
    }

    @PreAuthorize(value="hasRole('ROLE_USER')")
    @RequestMapping(value={"byclientid/{id}"}, produces={"application/json"})
    public String statsByClientId(@PathVariable(value="id") String clientId, ModelMap m) {
        ClientStat e = this.statsService.getCountForClientId(clientId);
        m.put((Object)"entity", (Object)e);
        return "jsonEntityView";
    }
}

