/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.token;

import java.util.Collection;
import java.util.Date;
import org.mitre.oauth2.exception.AuthorizationPendingException;
import org.mitre.oauth2.exception.DeviceCodeExpiredException;
import org.mitre.oauth2.model.DeviceCode;
import org.mitre.oauth2.service.DeviceCodeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.token.AbstractTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.stereotype.Component;

@Component(value="deviceTokenGranter")
public class DeviceTokenGranter
extends AbstractTokenGranter {
    public static final String GRANT_TYPE = "urn:ietf:params:oauth:grant-type:device_code";
    @Autowired
    private DeviceCodeService deviceCodeService;

    protected DeviceTokenGranter(AuthorizationServerTokenServices tokenServices, ClientDetailsService clientDetailsService, OAuth2RequestFactory requestFactory) {
        super(tokenServices, clientDetailsService, requestFactory, GRANT_TYPE);
    }

    protected OAuth2Authentication getOAuth2Authentication(ClientDetails client, TokenRequest tokenRequest) {
        String deviceCode = (String)tokenRequest.getRequestParameters().get("device_code");
        DeviceCode dc = this.deviceCodeService.findDeviceCode(deviceCode, client);
        if (dc != null) {
            if (dc.getExpiration() != null && dc.getExpiration().before(new Date())) {
                this.deviceCodeService.clearDeviceCode(deviceCode, client);
                throw new DeviceCodeExpiredException("Device code has expired " + deviceCode);
            }
            if (!dc.isApproved()) {
                throw new AuthorizationPendingException("Authorization pending for code " + deviceCode);
            }
            tokenRequest.setScope((Collection)dc.getScope());
            OAuth2Authentication auth = new OAuth2Authentication(this.getRequestFactory().createOAuth2Request(client, tokenRequest), (Authentication)dc.getAuthenticationHolder().getUserAuth());
            this.deviceCodeService.clearDeviceCode(deviceCode, client);
            return auth;
        }
        throw new InvalidGrantException("Invalid device code: " + deviceCode);
    }
}

