/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets.plaf;

import com.explodingpixels.macwidgets.WidgetBaseColors;
import com.explodingpixels.macwidgets.plaf.HudPaintingUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.JTextComponent;

public class HudTextFieldUI
extends BasicTextFieldUI {
    private boolean isDarkColorScheme = true;
    private Color fontColor = WidgetBaseColors.DARK_FONT_COLOR;

    public void installUI(JComponent c) {
        super.installUI(c);
        this.fontColor = this.isDarkColorScheme ? WidgetBaseColors.DARK_FONT_COLOR : WidgetBaseColors.LIGHT_FONT_COLOR;
        JTextComponent textComponent = (JTextComponent)c;
        textComponent.setOpaque(false);
        textComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(HudPaintingUtils.BORDER_COLOR), BorderFactory.createEmptyBorder(1, 2, 1, 2)));
        textComponent.setBackground(new Color(0, 0, 0, 0));
        textComponent.setForeground(this.fontColor);
        textComponent.setFont(HudPaintingUtils.getHudFont());
        textComponent.setSelectedTextColor(Color.BLACK);
        textComponent.setSelectionColor(this.fontColor);
        textComponent.setCaretColor(this.fontColor);
    }

    protected void paintSafely(Graphics graphics) {
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintSafely(graphics);
    }
}

