/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets;

import com.explodingpixels.macwidgets.DSourceListMail;
import com.explodingpixels.macwidgets.SourceList;
import com.explodingpixels.macwidgets.SourceListCategory;
import com.explodingpixels.macwidgets.SourceListExpansionListener;
import com.explodingpixels.macwidgets.SourceListItem;
import com.explodingpixels.widgets.WindowUtils;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class DSourceListExpansionListener {
    private static Object[] willExpandOptions = new Object[]{"Cancel Expansion", "Expand"};
    private static String willExpandText = "A branch node is about to be expanded.\nClick \"Cancel Expansion\" to prevent it.";
    private static String willExpandTitle = "Tree Will Expand";

    public static void main(String[] args) {
        final SourceListExpansionListener expansionListener = new SourceListExpansionListener(){

            public void sourceListItemExpanded(SourceListItem item) {
                System.out.println("SourceListItem " + item.getText() + " was expanded.");
            }

            public void sourceListItemCollapsed(SourceListItem item) {
                System.out.println("SourceListItem " + item.getText() + " was collapsed.");
            }

            public void sourceListCategoryExpanded(SourceListCategory category) {
                System.out.println("SourceListCategory " + category.getText() + " was expanded.");
            }

            public void sourceListCategoryCollapsed(SourceListCategory category) {
                System.out.println("SourceListCategory " + category.getText() + " was collapsed.");
            }

            public boolean shouldExpandSourceListItem(SourceListItem item) {
                int n = JOptionPane.showOptionDialog(null, willExpandText, willExpandTitle, 0, 3, null, willExpandOptions, willExpandOptions[1]);
                if (n == 0) {
                    return false;
                }
                System.out.println("SourceListItem " + item.getText() + " will be expanded.");
                return true;
            }

            public boolean shouldCollapseSourceListItem(SourceListItem item) {
                System.out.println("SourceListItem " + item.getText() + " will be collapsed.");
                return true;
            }

            public boolean shouldExpandSourceListCategory(SourceListCategory category) {
                System.out.println("SourceListCategory " + category.getText() + " will be expanded.");
                return true;
            }

            public boolean shouldToCollapseSourceListCategory(SourceListCategory category) {
                System.out.println("SourceListCategory " + category.getText() + " will be collapsed.");
                return true;
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SourceList sourceList = DSourceListMail.createSourceList();
                sourceList.addSourceListExpansionListener(expansionListener);
                JFrame frame = new JFrame();
                WindowUtils.createAndInstallRepaintWindowFocusListener((Window)frame);
                frame.add((Component)sourceList.getComponent(), "Center");
                frame.setSize(225, 250);
                frame.setLocationRelativeTo(null);
                frame.setDefaultCloseOperation(2);
                frame.setVisible(true);
            }
        });
    }
}

