/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets.plaf;

import com.explodingpixels.macwidgets.MacFontUtils;
import com.explodingpixels.macwidgets.MacWidgetFactory;
import com.explodingpixels.macwidgets.SourceListBadgeContentProvider;
import com.explodingpixels.macwidgets.SourceListCategory;
import com.explodingpixels.macwidgets.SourceListColorScheme;
import com.explodingpixels.macwidgets.SourceListCountBadgeRenderer;
import com.explodingpixels.macwidgets.SourceListStandardColorScheme;
import com.explodingpixels.painter.FocusStatePainter;
import com.explodingpixels.painter.RectanglePainter;
import com.explodingpixels.widgets.IconProvider;
import com.explodingpixels.widgets.TextProvider;
import com.explodingpixels.widgets.TreeUtils;
import com.explodingpixels.widgets.WindowUtils;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SourceListTreeUI
extends BasicTreeUI {
    private Font categoryFont = MacFontUtils.BOLD_LABEL_FONT;
    private Font itemFont = MacFontUtils.DEFAULT_LABEL_FONT;
    private Font itemSelectedFont = this.itemFont.deriveFont(1);
    private static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
    private final String SELECT_NEXT = "selectNext";
    private final String SELECT_PREVIOUS = "selectPrevious";
    private SourceListColorScheme fColorScheme;
    private FocusStatePainter fBackgroundPainter;
    private FocusStatePainter fSelectionBackgroundPainter;
    private CustomTreeModelListener fTreeModelListener = new CustomTreeModelListener();

    protected void completeUIInstall() {
        super.completeUIInstall();
        this.tree.setSelectionModel(new SourceListTreeSelectionModel());
        this.tree.setOpaque(false);
        this.tree.setRootVisible(false);
        this.tree.setLargeModel(true);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setRowHeight(20);
        this.setColorScheme(new SourceListStandardColorScheme());
    }

    public Font getCategoryFont() {
        return this.categoryFont;
    }

    public void setCategoryFont(Font categoryFont) {
        this.categoryFont = categoryFont;
    }

    public Font getItemFont() {
        return this.itemFont;
    }

    public void setItemFont(Font itemFont) {
        this.itemFont = itemFont;
    }

    public Font getItemSelectedFont() {
        return this.itemSelectedFont;
    }

    public void setItemSelectedFont(Font itemSelectedFont) {
        this.itemSelectedFont = itemSelectedFont;
    }

    protected void installListeners() {
        super.installListeners();
        WindowUtils.installJComponentRepainterOnWindowFocusChanged(this.tree);
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.tree.getInputMap().put(KeyStroke.getKeyStroke("pressed DOWN"), "selectNext");
        this.tree.getInputMap().put(KeyStroke.getKeyStroke("pressed UP"), "selectPrevious");
        this.tree.getActionMap().put("selectNext", this.createNextAction());
        this.tree.getActionMap().put("selectPrevious", this.createPreviousAction());
    }

    protected void setModel(TreeModel model) {
        if (this.treeModel != null) {
            this.treeModel.removeTreeModelListener(this.fTreeModelListener);
        }
        super.setModel(model);
        if (model != null) {
            model.addTreeModelListener(new CustomTreeModelListener());
        }
    }

    public SourceListColorScheme getColorScheme() {
        return this.fColorScheme;
    }

    public void setColorScheme(SourceListColorScheme colorScheme) {
        SourceListTreeUI.checkColorSchemeNotNull(colorScheme);
        this.fColorScheme = colorScheme;
        this.fBackgroundPainter = new FocusStatePainter(new RectanglePainter(this.fColorScheme.getActiveBackgroundColor()), new RectanglePainter(this.fColorScheme.getActiveBackgroundColor()), new RectanglePainter(this.fColorScheme.getInactiveBackgroundColor()));
        this.fSelectionBackgroundPainter = new FocusStatePainter(this.fColorScheme.getActiveFocusedSelectedItemPainter(), this.fColorScheme.getActiveUnfocusedSelectedItemPainter(), this.fColorScheme.getInactiveSelectedItemPainter());
        this.tree.setCellRenderer(new SourceListTreeCellRenderer());
        this.installDisclosureIcons();
    }

    private void installDisclosureIcons() {
        this.setCollapsedIcon(this.fColorScheme.getUnselectedCollapsedIcon());
        this.setExpandedIcon(this.fColorScheme.getUnselectedExpandedIcon());
        int indent = this.fColorScheme.getUnselectedCollapsedIcon().getIconWidth() / 2 + 4;
        this.setLeftChildIndent(indent);
        this.setRightChildIndent(indent);
    }

    protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        boolean isPathSelected = this.tree.getSelectionModel().isPathSelected(path);
        Icon expandIcon = isPathSelected ? this.fColorScheme.getSelectedExpandedIcon() : this.fColorScheme.getUnselectedExpandedIcon();
        Icon collapseIcon = isPathSelected ? this.fColorScheme.getSelectedCollapsedIcon() : this.fColorScheme.getUnselectedCollapsedIcon();
        Object categoryOrItem = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        boolean setIcon = !(categoryOrItem instanceof SourceListCategory) || ((SourceListCategory)categoryOrItem).isCollapsable();
        this.setExpandedIcon(setIcon ? expandIcon : null);
        this.setCollapsedIcon(setIcon ? collapseIcon : null);
        super.paintExpandControl(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
    }

    protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
        return new BasicTreeUI.NodeDimensionsHandler(){

            public Rectangle getNodeDimensions(Object value, int row, int depth, boolean expanded, Rectangle size) {
                Rectangle dimensions = super.getNodeDimensions(value, row, depth, expanded, size);
                int containerWidth = SourceListTreeUI.this.tree.getParent() instanceof JViewport ? SourceListTreeUI.this.tree.getParent().getWidth() : SourceListTreeUI.this.tree.getWidth();
                dimensions.width = containerWidth - this.getRowX(row, depth);
                return dimensions;
            }
        };
    }

    public Rectangle getPathBounds(JTree tree, TreePath path) {
        Rectangle bounds = super.getPathBounds(tree, path);
        if (bounds != null) {
            bounds.x = 0;
            bounds.width = tree.getWidth();
        }
        return bounds;
    }

    public void paint(Graphics g, JComponent c) {
        Graphics2D backgroundGraphics = (Graphics2D)g.create();
        this.fBackgroundPainter.paint(backgroundGraphics, c, c.getWidth(), c.getHeight());
        backgroundGraphics.dispose();
        int selectedRow = this.getSelectionModel().getLeadSelectionRow();
        if (selectedRow >= 0 && this.tree.isVisible(this.tree.getPathForRow(selectedRow))) {
            Rectangle bounds = this.tree.getRowBounds(selectedRow);
            Graphics2D selectionBackgroundGraphics = (Graphics2D)g.create();
            selectionBackgroundGraphics.translate(0, bounds.y);
            this.fSelectionBackgroundPainter.paint(selectionBackgroundGraphics, c, c.getWidth(), bounds.height);
            selectionBackgroundGraphics.dispose();
        }
        super.paint(g, c);
    }

    protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
    }

    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
    }

    protected void selectPathForEvent(TreePath path, MouseEvent event) {
        if (!this.isLocationInExpandControl(path, event.getX(), event.getY())) {
            super.selectPathForEvent(path, event);
        }
    }

    private Action createNextAction() {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                int selectedRow = SourceListTreeUI.this.tree.getLeadSelectionRow();
                for (int rowToSelect = selectedRow + 1; rowToSelect >= 0 && rowToSelect < SourceListTreeUI.this.tree.getRowCount(); ++rowToSelect) {
                    if (!SourceListTreeUI.this.isItemRow(rowToSelect)) continue;
                    SourceListTreeUI.this.tree.setSelectionRow(rowToSelect);
                    break;
                }
            }
        };
    }

    private Action createPreviousAction() {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                int selectedRow = SourceListTreeUI.this.tree.getLeadSelectionRow();
                for (int rowToSelect = selectedRow - 1; rowToSelect >= 0 && rowToSelect < SourceListTreeUI.this.tree.getRowCount(); --rowToSelect) {
                    if (!SourceListTreeUI.this.isItemRow(rowToSelect)) continue;
                    SourceListTreeUI.this.tree.setSelectionRow(rowToSelect);
                    break;
                }
            }
        };
    }

    private boolean isCategoryRow(int row) {
        return !this.isItemRow(row);
    }

    private boolean isItemRow(int row) {
        return this.isItemPath(this.tree.getPathForRow(row));
    }

    private boolean isItemPath(TreePath path) {
        return path != null && path.getPathCount() > 2;
    }

    private String getTextForNode(TreeNode node, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String retVal;
        if (node instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)node).getUserObject() instanceof TextProvider) {
            Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
            retVal = ((TextProvider)userObject).getText();
        } else {
            retVal = this.tree.convertValueToText(node, selected, expanded, leaf, row, hasFocus);
        }
        return retVal;
    }

    private Icon getIconForNode(TreeNode node) {
        Icon retVal = null;
        if (node instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)node).getUserObject() instanceof IconProvider) {
            Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
            retVal = ((IconProvider)userObject).getIcon();
        }
        return retVal;
    }

    private static void checkColorSchemeNotNull(SourceListColorScheme colorScheme) {
        if (colorScheme == null) {
            throw new IllegalArgumentException("The given SourceListColorScheme cannot be null.");
        }
    }

    private class SourceListTreeSelectionModel
    extends DefaultTreeSelectionModel {
        public SourceListTreeSelectionModel() {
            this.setSelectionMode(1);
        }

        private boolean canSelect(TreePath path) {
            return SourceListTreeUI.this.isItemPath(path);
        }

        public void setSelectionPath(TreePath path) {
            if (this.canSelect(path)) {
                super.setSelectionPath(path);
            }
        }

        public void setSelectionPaths(TreePath[] paths) {
            if (this.canSelect(paths[0])) {
                super.setSelectionPaths(paths);
            }
        }
    }

    private class ItemTreeCellRenderer
    implements TreeCellRenderer {
        private PanelBuilder fBuilder;
        private SourceListCountBadgeRenderer fCountRenderer;
        private JLabel fSelectedLabel;
        private JLabel fUnselectedLabel;

        private ItemTreeCellRenderer() {
            this.fCountRenderer = new SourceListCountBadgeRenderer(SourceListTreeUI.this.fColorScheme.getSelectedBadgeColor(), SourceListTreeUI.this.fColorScheme.getActiveUnselectedBadgeColor(), SourceListTreeUI.this.fColorScheme.getInativeUnselectedBadgeColor(), SourceListTreeUI.this.fColorScheme.getBadgeTextColor());
            this.fSelectedLabel = MacWidgetFactory.makeEmphasizedLabel(new JLabel(), SourceListTreeUI.this.fColorScheme.getSelectedItemTextColor(), SourceListTreeUI.this.fColorScheme.getSelectedItemTextColor(), SourceListTreeUI.this.fColorScheme.getSelectedItemFontShadowColor());
            this.fUnselectedLabel = MacWidgetFactory.makeEmphasizedLabel(new JLabel(), SourceListTreeUI.this.fColorScheme.getUnselectedItemTextColor(), SourceListTreeUI.this.fColorScheme.getUnselectedItemTextColor(), TRANSPARENT_COLOR);
            FormLayout layout = new FormLayout("fill:0px:grow, 5px, p, 5px", "3px, fill:p:grow, 3px");
            this.fBuilder = new PanelBuilder(layout);
            this.fBuilder.getPanel().setOpaque(false);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object userObject;
            SourceListBadgeContentProvider badgeContentProvider;
            this.fSelectedLabel.setFont(SourceListTreeUI.this.getItemSelectedFont());
            this.fUnselectedLabel.setFont(SourceListTreeUI.this.getItemFont());
            TreeNode node = (TreeNode)value;
            JLabel label = selected ? this.fSelectedLabel : this.fUnselectedLabel;
            label.setText(SourceListTreeUI.this.getTextForNode(node, selected, expanded, leaf, row, hasFocus));
            label.setIcon(SourceListTreeUI.this.getIconForNode(node));
            this.fBuilder.getPanel().removeAll();
            CellConstraints cc = new CellConstraints();
            this.fBuilder.add((Component)label, cc.xywh(1, 1, 1, 3));
            if (value instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)value).getUserObject() instanceof SourceListBadgeContentProvider && (badgeContentProvider = (SourceListBadgeContentProvider)(userObject = ((DefaultMutableTreeNode)node).getUserObject())).getCounterValue() > 0) {
                this.fBuilder.add((Component)this.fCountRenderer.getComponent(), cc.xy(3, 2, "center, fill"));
                this.fCountRenderer.setState(badgeContentProvider.getCounterValue(), selected);
            }
            return this.fBuilder.getPanel();
        }
    }

    private class CategoryTreeCellRenderer
    implements TreeCellRenderer {
        private JLabel fLabel;

        private CategoryTreeCellRenderer() {
            this.fLabel = MacWidgetFactory.makeEmphasizedLabel(new JLabel(), SourceListTreeUI.this.fColorScheme.getCategoryTextColor(), SourceListTreeUI.this.fColorScheme.getCategoryTextColor(), SourceListTreeUI.this.fColorScheme.getCategoryTextShadowColor());
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.fLabel.setFont(SourceListTreeUI.this.getCategoryFont());
            TreeNode node = (TreeNode)value;
            this.fLabel.setText(SourceListTreeUI.this.getTextForNode(node, selected, expanded, leaf, row, hasFocus).toUpperCase());
            return this.fLabel;
        }
    }

    private class SourceListTreeCellRenderer
    implements TreeCellRenderer {
        private CategoryTreeCellRenderer iCategoryRenderer;
        private ItemTreeCellRenderer iItemRenderer;

        private SourceListTreeCellRenderer() {
            this.iCategoryRenderer = new CategoryTreeCellRenderer();
            this.iItemRenderer = new ItemTreeCellRenderer();
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            TreeCellRenderer render = SourceListTreeUI.this.isCategoryRow(row) ? this.iCategoryRenderer : this.iItemRenderer;
            return render.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
    }

    private class CustomTreeModelListener
    implements TreeModelListener {
        private CustomTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent e) {
        }

        public void treeNodesInserted(TreeModelEvent e) {
            TreePath path = e.getTreePath();
            Object root = SourceListTreeUI.this.tree.getModel().getRoot();
            TreePath pathToRoot = new TreePath(root);
            if (path != null && path.getParentPath() != null && path.getParentPath().getLastPathComponent().equals(root) && !SourceListTreeUI.this.tree.isExpanded(pathToRoot)) {
                TreeUtils.expandPathOnEdt(SourceListTreeUI.this.tree, new TreePath(root));
            }
        }

        public void treeNodesRemoved(TreeModelEvent e) {
        }

        public void treeStructureChanged(TreeModelEvent e) {
        }
    }
}

