/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets;

import com.explodingpixels.macwidgets.WidgetColorScheme;
import com.explodingpixels.macwidgets.WidgetStandardColorScheme;
import com.explodingpixels.widgets.WindowUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import javax.swing.JPanel;

public class ActivePanel
extends JPanel {
    private static final long serialVersionUID = -7894860504157071021L;
    WidgetColorScheme colorScheme = new WidgetStandardColorScheme();

    public ActivePanel() {
        this.initialize();
    }

    public ActivePanel(LayoutManager layout) {
        super(layout);
        this.initialize();
    }

    public ActivePanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.initialize();
    }

    public ActivePanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.initialize();
    }

    public ActivePanel(WidgetColorScheme colorScheme) {
        this.colorScheme = colorScheme;
        this.initialize();
    }

    public ActivePanel(LayoutManager layout, WidgetColorScheme colorScheme) {
        super(layout);
        this.colorScheme = colorScheme;
        this.initialize();
    }

    public ActivePanel(boolean isDoubleBuffered, WidgetColorScheme colorScheme) {
        super(isDoubleBuffered);
        this.colorScheme = colorScheme;
        this.initialize();
    }

    public ActivePanel(LayoutManager layout, boolean isDoubleBuffered, WidgetColorScheme colorScheme) {
        super(layout, isDoubleBuffered);
        this.colorScheme = colorScheme;
        this.initialize();
    }

    protected void initialize() {
        WindowUtils.installJComponentRepainterOnWindowFocusChanged(this);
    }

    public void paint(Graphics g) {
        boolean containedInActiveWindow = WindowUtils.isParentWindowFocused(this);
        Color color = containedInActiveWindow ? this.colorScheme.getActiveBackgroundColor() : this.colorScheme.getInactiveBackgroundColor();
        this.setBackground(color);
        int w = this.getWidth();
        int h = this.getHeight();
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(color);
        g2.fillRect(0, 0, w, h);
        this.paintChildren(g2);
    }
}

