/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets;

import com.explodingpixels.macwidgets.DSourceListMail;
import com.explodingpixels.macwidgets.SourceList;
import com.explodingpixels.macwidgets.SourceListCategory;
import com.explodingpixels.macwidgets.SourceListClickListener;
import com.explodingpixels.macwidgets.SourceListItem;
import com.explodingpixels.widgets.WindowUtils;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class DSourceListClickListener {
    private static String getPluralModifer(int clickCount) {
        return clickCount == 1 ? "" : "s";
    }

    public static void main(String[] args) {
        final SourceListClickListener clickListener = new SourceListClickListener(){

            public void sourceListItemClicked(SourceListItem item, SourceListClickListener.Button button, int clickCount) {
                System.out.println(item.getText() + " clicked " + clickCount + " time" + DSourceListClickListener.getPluralModifer(clickCount) + ".");
            }

            public void sourceListCategoryClicked(SourceListCategory category, SourceListClickListener.Button button, int clickCount) {
                System.out.println(category.getText() + " clicked " + clickCount + " time" + DSourceListClickListener.getPluralModifer(clickCount) + ".");
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SourceList sourceList = DSourceListMail.createSourceList();
                sourceList.addSourceListClickListener(clickListener);
                JFrame frame = new JFrame();
                WindowUtils.createAndInstallRepaintWindowFocusListener((Window)frame);
                frame.add((Component)sourceList.getComponent(), "Center");
                frame.setSize(225, 250);
                frame.setLocationRelativeTo(null);
                frame.setDefaultCloseOperation(2);
                frame.setVisible(true);
            }
        });
    }
}

