/*
 * Decompiled with CFR 0.152.
 */
package de.javastream.java.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IpCache {
    private static final Logger LOG = Logger.getLogger(IpCache.class.getSimpleName());
    private static IpCache instance = null;

    private IpCache() {
    }

    public static IpCache getInstance() {
        if (instance == null) {
            instance = new IpCache();
        }
        return instance;
    }

    public List<String> getLocalIpv4s() {
        ArrayList<String> ips = new ArrayList<String>();
        ips.add("127.0.0.1");
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface current = interfaces.nextElement();
                if (!current.isUp() || current.isLoopback() || current.isVirtual()) continue;
                Enumeration<InetAddress> addresses = current.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress current_addr = addresses.nextElement();
                    String ip = current_addr.getHostAddress().trim();
                    if (ip == null || ip.startsWith("fe") || ip.length() > 15 || current_addr.isLoopbackAddress()) continue;
                    ips.add(ip);
                }
            }
            LOG.log(Level.FINER, "found {0} local ips", ips.size());
        }
        catch (SocketException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        return ips;
    }
}

