/**
 * @file Copyright (c) 2011 jdknight
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package de.javastream.java.net.jmac;

/**
 * Exception thrown when the current operating system is not supported.
 */
public class UnsupportedOperatingSystemException extends Exception {

    /**
     * Serialization Id.
     *
     */
    private static final long serialVersionUID = 7580962732015860772L;

    /**
     * Initializes a new instance of UnsupportedOperatingSystemException.
     */
    public UnsupportedOperatingSystemException() {
        super();
    }

    /**
     * Initializes a new instance of UnsupportedOperatingSystemException.
     *
     * @param message The detail message.
     */
    public UnsupportedOperatingSystemException(String message) {
        super(message);
    }
}
